// -*- mode: objc
// Template application. Copyright  1996-1999 Santa Fe Institute.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import <objectbase.h>
#import <simtoolsgui.h>
#import <analysis.h> // EZGraph
#import "PopSwarm.h"

#import <simtoolsgui/GUISwarm.h>

// Sample graphical interface swarm for models.
@interface PopulationObserverSwarm: GUISwarm
{
  int displayFrequency;
  
  id displayActions;
  id displaySchedule;
  
  id <EZGraph> fitnessGraph;			  // graphing widget

  // MODIFY: add display objects
  unsigned chromLen;
  float (*evalFunc) (id<Chromosome>); // Evaluation Function
  PopulationSwarm *populationSwarm;
}

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

// Other methods
- setChromLength: (unsigned)_len;
- setEvaluationFunc: (float (*)(id))_evalFunc;
- checkToStop;
@end
