
// AgentProbaCamera.h


/*
static char Id="$Id: AgentProbaCamera.h,v 1.2 1997/04/02 09:23:40 chantem Exp chantem $"
*/


#import <swarmobject.h>	 // we inherit swarm objects
#import <tkobjc/Raster.h> // special class for graphics
#import "WorldObject.h" // we also have a WorldObject object
#import <vision/Camera.h>
#import <vision/TwoD.h>

#define PI M_PI
#define TwoPI 2*M_PI
#define PI_4 M_PI/4
#define PI_2 M_PI/2
#define ThreePI_2 3*M_PI/2
#define ThreePI_4 3*M_PI/4
#define FivePI_4 5*M_PI/4
#define SevenPI_4 7*M_PI/4
#define PI_8 M_PI/8

// We inherit code from the generic SwarmObject, which provides memory
// allocation and other niceties.

@interface AgentProbaCamera: SwarmObject {
  int x, y; // my spatial coordinates
  float alpha;
  int carriedObject;
  double rotAngle;
  Grid2d *worldAgent; // the world agents live in
  int worldXSize, worldYSize; // how big that world is
  WorldObject *worldObject;// the world containing objects
  Color agtColor; // my colour (display)
  id randGAgt; // my own random generator for displacements
  id uRandAgt;
  int seedValueAgt;
  id randGAgtOb; // my own random generator for deciding to take an object or not
  id uRandAgtOb;
  int seedValueAgtOb;
  id randGAgtCCW; // my own random generator for deciding clockwise or counterclockwise rotating
  id uRandAgtCCW;
  int seedValueAgtCCW;
  id pixellist; // list of 2D points
  Camera *camera;
  int nbPointSeen;
  int nberOfRotOnSite;
  int CWCCWRotation; // to choose between clockwise or conterclock: not used now, but in a short time
}

-setWorlds: (Grid2d *) wAgt: (WorldObject *) wObj; // which world are we in?
-createEnd;

-setX: (int) x Y: (int) y; // agt's position
-setRotAngle: (double)val;
-(double)getRotAngle;
-setCameraInit;

-(id)getCamera;

-setAgtColor: (Color) c; // agt's colour (display)

-setAlpha: (float)a;
-(float)getAlpha;
-setNbPointSeen: (int)val;
-(int)getNbPointSeen;

-setNberOfRotOnSite: (int)val;
-(int)getNberOfRotOnSite;
-setCWCCWRotation:(int)val;
-(int)getCWCCWRotation;
-setSeedDispl: (int)value;
-setSeedCarrying: (int)value;
-(int)getSeedDispl;
-(int)getSeedCarrying;
-setSeedCCW: (int)value;
-(int)getSeedCCW;
-setCarriedObj:(int)value;
-(int)getCarriedObj;

// The major agent behaviour: do one "time step" (all agt action).
-step;

// to convert into direction (0, ..., 7) the orientation
-(int)determinesIntervalAngle: (double)angle;
-(double)determinesAngle: (int)value;

// computation of new coordinates for the displacement of the agent
-computesCoordAndOrien: (int)intervalAng: (double)angle: (int *)new_x: (int *)new_y: (double *)rotation_angle;

// draws randomly new coordinates and new orientation versus the bound (upper limit):
// example: bound = 4 means, random drawing in integer 0, 1, 2, 3
-randomChoice: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;

-randomChoiceUpLeftCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLoLeftCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLeftBorder: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceUpRightCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLoRightCorner: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceRightBorder: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceUpRow: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;
-randomChoiceLoRow: (int)bound: (int *)new_x: (int *)new_y: (double *)rotation_angle;

-RandomDrawingOnBoundGrid: (int *)newx: (int *)newy: (double *)rotation_angle;

-(int)neighbourhood:(int *)new_x: (int *)new_y: (double *)rotation_angle;
-(int)calculateLocation;

// extra display code (agents currently draw themselves)
-drawSelfOn: (Raster *) r;

@end

/*
$Log: AgentProbaCamera.h,v $
Revision 1.2  1997/04/02 09:23:40  chantem
can no choose to rotate counter clockwise or clockwise

Revision 1.1  1997/04/02 08:59:58  chantem
Initial revision

Revision 1.1  1997/03/25 11:45:42  chantem
Initial revision

*/
