// WorldObject.h


/*
static char Id="$Id: WorldObject.h,v 1.1 1997/04/02 08:59:58 chantem Exp chantem $"
*/

#import <space.h>
#import "Stack.h"
#import <vision/ThreeD.h>

// The maximum value a square can use: just for the visualization
extern const int basisColorForObj;
extern const int backgroundColor;

// Class WorldObject. Inherit from Discrete2d
@interface WorldObject : Discrete2d {
  int InitNbObj; // number of objects in the WorldObject at the outset
  int CurNbStacks; // current number of stacks
  int BiggestStack; // size of the biggest stack: expressed in nber of objects
  id stackList; // list of all the stack locations and their features
  id threeDList; // list of simulated 3D points
}

// init number of objects and stacks: at the outset: 1 object per stack!
// so, number of stacks is equal to number of objects 
-InitNumberOfObj: (int)value;

// set objects and stacks
-InitSetObjects: (int)seedValueObjects;

-(int)getObjects: (int)x: (int)y;
-(int)getStacks;
-(int)getInitObj;
-(int)getBiggestStack;

-getThreeDList;
-getStackList;
-addStack: (STack *) st;

-AddObjects: (int) v: (int)x: (int)y;
-RemoveObjects: (int) v: (int)x: (int)y;
-UpdateBiggestStack;

@end

/*
$Log: WorldObject.h,v $
Revision 1.1  1997/04/02 08:59:58  chantem
Initial revision

Revision 1.1  1997/03/25 11:45:42  chantem
Initial revision

*/
