// WorldObject.m


/*
static char Id="$Id: WorldObject.m,v 1.1 1997/04/02 09:00:08 chantem Exp chantem $";
*/

#import "WorldObject.h"
#import <simtools.h>

// be sure colorOffset is slightly different from backgroundColor

const int basisColorForObj = 30000; // something close to red: red is theroretically 31744!
				    // as the background is white (33280), with such a base for
                                    // the color of objects, we can tolerate around 2000 of objects.
const int backgroundColor = 33280; //for white.


@implementation WorldObject


-InitNumberOfObj: (int)value
{
  InitNbObj = value;
  CurNbStacks = value;
  BiggestStack = value/value; // 1 object per cell and therefore per stack at start
  //printf("nb objects=%d\n", InitNbObj);
  //printf("nb stacks=%d\n", CurNbStacks);
  //printf("%d objects in the biggest stack\n", BiggestStack);
  // we create a list to keep track of the stacks in the world.
  stackList = [List create: [self getZone]];
  // we create another list to keep track of the coordinates of the points in the world.
  threeDList = [List create: [self getZone]];
  return self;
}

// setObjects and stacks: representation by colors
-InitSetObjects: (int)seedValueObjects
{
  int chosenX, chosenY;
  int i;
  id randGen;
  id uniRand;

  //randGen = [[PMMLCG1 alloc] initSeed: seedValueObjects];	  // seeds from clock
  //uniRand = [[[Uniform alloc] init] setGenerator: randGen];

  // for the generator
  randGen = [PMMLCG1 createBegin: [self getZone]];
  [randGen setStateFromSeed: seedValueObjects];
  randGen = [randGen createEnd]; 
  // for the distribution
  uniRand = [UniformInteger createBegin: [self getZone]];
  [uniRand setGenerator: randGen];
  uniRand = [uniRand createEnd];

  for (i=0; i<InitNbObj; i++) {
    STack *sta;
    Point3D *pt;
    int ind;

    // random position
    //chosenX = [uniRand rMax: [self getSizeX]]; 
    //chosenY = [uniRand rMax: [self getSizeY]];
    chosenX = [uniRand getIntegerWithMin: 0L withMax: [self getSizeX]-1];
    chosenY = [uniRand getIntegerWithMin: 0L withMax: [self getSizeY]-1];
    while ([self getValueAtX: chosenX Y: chosenY] != backgroundColor) { // we check if something is already here
      //printf("chosenX = %d, chosenY = %d\n", chosenX, chosenY);
      // random position
      //chosenX = [uniRand rMax: [self getSizeX]]; 
      //chosenY = [uniRand rMax: [self getSizeY]];
      chosenX = [uniRand getIntegerWithMin: 0L withMax: [self getSizeX]-1];
      chosenY = [uniRand getIntegerWithMin: 0L withMax: [self getSizeY]-1];
    }
    //printf("chosenX = %d, chosenY = %d\n", chosenX, chosenY);
    [self putValue: (int)(basisColorForObj+1) atX: chosenX Y: chosenY]; // here we have a redundant information:
    // the number of objects is kept in the worldObject table and in the stackList list
    // we did it intentionally for at least two reasons: first, the access to worldObject to get the number
    // of objects on a particular cell is faster, you just need to substract the basisColorForObj, useful only for 
    // visualization. If you try to access stackList, you need to convert 
    // x, y coordinates into an offset coordinate. Secondly, if you want to represent the color of the stacks
    // scaling with the number of objects present into the stacks, it is worthwhile to do it.  
    //printf("object in x=%d, y=%d\n", chosenX, chosenY);

    // Create the stack, set the creation time variables
    sta = [STack createBegin: [self getZone]];
    ind = [self getSizeX]*chosenY + chosenX;
    sta = [sta createEnd];
    // Add the stack to the end of the list.
    [sta setParameters: ind: 1]; // 1 because size is 1, so directly set: this is the basic assumption we make
    [stackList addLast: sta];
    // create a 3D point: useful for the vision simulation; we need a 3D point list.
    pt = [Point3D createBegin: [self getZone]];
    pt = [pt createEnd];
    // to express in a world system where:
    // X world is Y of swarm world, Y world is virtual X of swarm (virtual height), Z world is Z swarm size
    [pt setParam: 1: chosenX: chosenY: i]; // hypothesis height is equal to 1 by default!
    [threeDList addLast: pt];
    //printf("point %d: x= %d, y= %d, z= %d\n", [[threeDList atOffset: i] sendlabel],
    //                                          [[threeDList atOffset: i] sendx],  
    //                                          [[threeDList atOffset: i] sendy],
    //                                          [[threeDList atOffset: i] sendz]);
  }
  return self;
}

-(int)getObjects: (int)x: (int)y
{
  int numObj;

  numObj = [self getValueAtX: x Y: y];
  if ((numObj - backgroundColor) == 0) {
    numObj = 0;
  } else {
    numObj -= basisColorForObj; 
  }

  return numObj;
}

-(int)getStacks
{
  return CurNbStacks;
}

-(int)getBiggestStack
{
  return BiggestStack;
}

-getThreeDList {
  return threeDList;
}

-getStackList {
  return stackList;
}

// normally only done at the beginning of the experiment
-addStack: (STack *) st {
  [stackList addLast: st];
  return self;
}

-(int)getInitObj
{
  return InitNbObj;
}

-AddObjects: (int)v: (int)x: (int)y
{
  int size; // just the number of objects
  int of, i=0;
  int true=0;

  of = x + ([self getSizeX]*y);
  while ((true == 0)&& (i<CurNbStacks)) {
    if ([[stackList atOffset: i] getOff] == of) { // we found the cell, whose stack will be modified
      true = 1;
    }
    i+=1;
  }
  i-=1; // due to the incrementation when leaving while loop
  if (i>=CurNbStacks) {
    printf("runs out of range in AddObjects function\n"); // just in case of ...
  } else {
    size = [[stackList atOffset: i] getSize] + v;
    [[stackList atOffset: i] setParameters: of: size];
    //[[threeDList atOffset: i] setParam: x: v: y: i];
    [[threeDList atOffset: i] setParam: size: x: y: i];
    if (size > BiggestStack) BiggestStack = size;
    // update worldObject with new size + colorOffset
    [self putValue: size+basisColorForObj atX: x Y:y];
  }
  //printf("now %d object on cell x=%d, y=%d\n", size, x, y);
  //printf("the biggest stack has %d objects\n", BiggestStack);
  return self;
}

-UpdateBiggestStack
{
  int i, max;

  max = [[stackList atOffset: 0] getSize];
  // we scan all the list
  for (i=1; i<CurNbStacks; i++) {
    if ([[stackList atOffset: i] getSize] > max) { // we found the cell, whose stack will be modified
      max = [[stackList atOffset: i] getSize];
    }
  }
  BiggestStack = max;
  //printf("the biggest stack has %d objects\n", BiggestStack);
  return self;
}

-RemoveObjects: (int)v: (int)x: (int)y
{
  int of, i=0, true=0, oldsize, newsize;


  of = x + ([self getSizeX]*y);
  //printf("Remove object in cell x = %d, y = %d\n", x, y);

  while ((true == 0)&& (i<CurNbStacks)) {
    if ([[stackList atOffset: i] getOff] == of) { // we found the cell, whose stack will be modified
      true=1;
    }
    i+=1;
  }
  i-=1; // due to the incrementation when leaving while loop
  if (i>=CurNbStacks) {
    printf("runs out of range in RemoveObjects function\n"); // just in case of ...
  } else {
    oldsize = [[stackList atOffset: i] getSize]; 
    newsize = oldsize + v; // update size
    //printf("new size will be: %d\n", newsize);
    if (newsize == 0) {
      // is empty now: update worldObject with backgroundColor, no more object
      [self putValue: (newsize+backgroundColor) atX: x Y:y]; // no more objects: backgroundColor is for display, remember we have an offset otherwise
      //printf("now %d object on cell x=%d, y=%d\n", newsize, x, y);
    } else {
      // update worldObject with new size + colorOffset
      [self putValue: basisColorForObj+newsize atX: x Y:y];
      // update element of stackList with new size
      [[stackList atOffset: i] setParameters: of: newsize];
      //[[threeDList atOffset: i] setParam: x: newsize: y: i];
      [[threeDList atOffset: i] setParam: newsize: x: y: i];
      //printf("now %d object on cell x=%d, y=%d\n", newsize, x, y);
    }
  }
  
  // remove objects with null size and update the number of stacks
  if (newsize==0) {
    // one stack has to disappear
    [stackList remove: [stackList atOffset: i]];
    [threeDList remove: [threeDList atOffset: i]];
    CurNbStacks -=1;
    //printf("one stack removed, number is now: %d\n", CurNbStacks);
    //printf("the biggest stack has %d objects\n", BiggestStack);
  } else {
    if (oldsize == BiggestStack) {
      // we check here if there is another larger stack, because we will now decrement one stack,
      // that was one of the biggest.
      [self UpdateBiggestStack];
    } else {} // anonymous stack
  }
 
  return self;
}


@end

/*
$Log: WorldObject.m,v $
Revision 1.1  1997/04/02 09:00:08  chantem
Initial revision

Revision 1.1  1997/03/25 12:40:14  chantem
Initial revision

*/