// Sort.m
// implements sorting routines for sorting objects on [Object GetKey]

#import "Sort.h"
#import "Agent.h"

@implementation Sort

-(int) iPartition: (id *) a start: (int) begin finish: (int) end 
{
  int left, right;
  unsigned sel;		
  id temp;		
    

  sel = [a[begin] iGetKey];
  left = begin - 1;	
  right = end + 1;

  while (1) {
    while( [a[--right] iGetKey] > sel );
    while( [a[++left] iGetKey]< sel );

    if (left < right) {	
       temp = a[right];	
       a[right] = a[left];
       a[left] = temp;
    } else {
      return right;
    }
  }
}

-iQuickSort: (id *) a start: (int) begin finish: (int) end
{
  int pivot;

  if (begin < end) {
    pivot = [self iPartition: a start: begin finish: end];
    [self iQuickSort: a start: begin finish: pivot];
    [self iQuickSort: a start: (pivot+1) finish: end];
  }
  return self;
}

-(int) dPartition: (id *) a start: (int) begin finish: (int) end 
{
  int left, right;
  double sel;		
  id temp;		
    

  sel = [a[begin] dGetKey];
  left = begin - 1;	
  right = end + 1;

  while (1) {
    while( [a[--right] dGetKey] > sel );
    while( [a[++left] dGetKey]< sel );

    if (left < right) {	
       temp = a[right];	
       a[right] = a[left];
       a[left] = temp;
    } else {
      return right;
    }
  }
  return self;
}

-dQuickSort: (id *) a start: (int) begin finish: (int) end
{
  int pivot;

  if (begin < end) {
    pivot = [self dPartition: a start: begin finish: end];
    [self dQuickSort: a start: begin finish: pivot];
    [self dQuickSort: a start: (pivot+1) finish: end];
  }
  return self;
}

-iStableSort: (id *) a start: (int) begin finish: (int) end
// this is a bubble sort!
{
   int i,j;
   id temp;
	
   for (i=end;i>=begin;i--)
     for(j=1;j<=i;j++)
       if ([a[j-1] iGetKey] > [a[j] iGetKey]) {
	 temp = a[j];	
	 a[j] = a[j-1];
	 a[j-1] = temp;
       }
   return self;
}

@end
