// World.m
// code for methods belonging to World object class

#import "World.h"
#import "Agent.h"

@implementation World

-setNumberAgents: (int) pop
{
  num_agents = pop;

  return self;
}

-setPlayers: (id *) p
{
  player = p;

  return self;
}

-setInteract: (Interact *) comp
{
  compete = comp;

  return self;
}

-setPopStep: (PopStep *) ga
{
  update = ga;

  return self;
}

-setSort: (Sort *) s
{
  sort = s;

  return self;
}

-setTmpArray
{
  int i;

  if (tmpArray != NULL) {
    free(tmpArray);
  }
  tmpArray = (id *) malloc(num_agents * sizeof(id));

  for (i=0;i<num_agents;i++) {
    tmpArray[i] = player[i];
  }

  return self;
}

-stepSpatial
{
  [compete spatialInteract: self X: xsize Y: ysize];
  avg_score = [self computeSpatialAverage];

  [update reproduceSpatial: player number: num_agents];
  [update mutate: player number: num_agents];

  return self;
}

-(double) computeSpatialAverage
{
  int i;
  double avg;

  avg = 0;
  for (i=0;i<num_agents;i++) {
    avg += [player[i] getAverage];	     
  }
  avg /= num_agents;

  return (avg);
}
  
-(id) getAgent: (int) i
{
  return (player[i]);
}

-(double) getAverage
{
  return (avg_score);
}

-printSpatialStrategies
{
  int i,count;
  unsigned j,k;
  char m,n;
  
  for (i=0;i<num_agents;i++) {
    [tmpArray[i] iSetKey: [tmpArray[i] getStrategy]];
  }

  [sort iStableSort: tmpArray start: 0 finish: (num_agents - 1)];

  for (i=0;i<num_agents;i++) {
    [tmpArray[i] iSetKey: (unsigned) [tmpArray[i] getMemory]];
  }

  [sort iStableSort: tmpArray start: 0 finish: (num_agents - 1)];


  j = [tmpArray[0] getStrategy];
  m = [tmpArray[0] getMemory];
  count=1;

  for (i=1,k=0,n=1;i<num_agents;i++) {
    k = [tmpArray[i] getStrategy];
    n = [tmpArray[i] getMemory];
    if (j==k && m==n) {
      count++;
    } else {
      printf("Strategy 0x%x Memory %d used by %d agent(s)\n",j,(int) m,count);
      count=1;
      j=k;
      m=n;
    }
  }

  if (j==k && m==n) {
    printf("Strategy 0x%x Memory %d used by %d agent(s)\n",j,(int) m,count);
  }
  
  return self;
}


-printSpatialWorld
{
  int i,j;
  
  for (i=0;i<ysize;i++) {
    for (j=0;j<xsize;j++) {
      printf("0x%x ",[[self getObjectAtX: j Y: i] getStrategy]);
    }
    printf("\n");
  }
  
  return self;
}

@end








