// $Id: NaSchSingleHighway.m,v 1.1 2001/01/22 15:10:01 ralf Exp $

#import "NaSchSingleHighway.h"
#import <random.h>
#import <activity.h>
#import "NaSchSingleCar.h"

@implementation NaSchSingleHighway


//---------------------------
- buildObjects
{
	int i;
	id zone = [self getZone];

	for (i=0; i<myDensity*mySize; i++)
	{
		id car;
		int X;
		
		do X = [uniformIntRand getIntegerWithMin: 0 withMax: mySize-1];
		while ([world getObjectAtX: X Y: myY] != nil);
		
		car = [NaSchSingleCar createBegin: zone];
		[car setX: X Y: myY];
		[car setV: [uniformIntRand getIntegerWithMin: 1 withMax: myVMax]];
		[car setWorld: world];
		[car setVMax: myVMax pDecel: myP];
		[car setDetector: myDetector atX: mySize/2];
		car = [car createEnd];
		[world putObject: car atX: X Y: myY];
		[myCars addFirst: car];
	}
	return self;
}

//---------------------------------------
- buildActions
{
	id actions = [ActionGroup create: self];

	[self createAction: actions forEachCar: M(accelerate)];
	[self createAction: actions forEachCar: M(brake)];
	[self createAction: actions forEachCar: M(randomize)];
	[self createAction: actions forEachCar: M(drive)];

	mySchedule = [Schedule createBegin: self];
	[mySchedule setRepeatInterval: 1];
	mySchedule = [mySchedule createEnd];
	[mySchedule at: 0 createAction: actions];

	return self;
}

@end
