#import "Species.h"
#import "Agent.h"

@class FishSpecies;

@interface FishSpecies: Species 
{}
+ getInstance;                           // singleton
@end


@interface Fish: Agent
{
@protected
	double myEnergyLimit;
	double foodFactor;                    // energy freed when eaten
}

+ createBegin: aZone;
- (void) setFoodFactor: (double) d;
- (void) setEnergyLimit: (double) d;
- createEnd;
- copy: aZone;
- (void) step;
- (double) getFoodValue;
- (void) dissolve;                         // retire from world

@end

