// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#ifndef _CRNN_H
#define _CRNN_H

#include "neuron.h"

//Implementation of Beer's continuous recurrent neural networks,
//except that all time constants are the same.

@interface CRNN:SwarmObject <NN, Recurrent> {
    unsigned numNeurons;
    float *y, *yPlus,		// neuron activation, t and t+1
	*inputs, *bias,		// Inputs and biases
	*weights, *taus;	// Weights and time constants
}
@end
#endif
