// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

// -*- mode: objc; c-indent-level: 4; comment-column: 35 -*-

// This version 2 attempts compatibility with Swarm

// Version 3 starts to use graphics

// Version 4 uses forms

// Version kkheb2ly es igual, pero para una hebbiana de dos capas...

// Now compiles cleanly for swarm version 0807

// kkcl.m es una adaptacion, para probar CompLearning

#include <stdlib.h>		// For calloc and free

#import <defobj.h>
#import <tkobjc.h>		// For all the definitions and stuff
#import <simtools.h>		// For simulation parameters

#import "CRNN.h"		// CRNN declarations

#define WIDTH 400
#define HEIGHT 250
//___________________________________________________________
void main( int argc, char** argv) {

  unsigned numNeurons = 2;

  id aZone;			// Allocation zone
  id neura;			// Neural network
  Entry * aEntry;		// To get number of neurons
  Label * aLabel;
  ControlPanel *controlPanel;	// Usually in GUISwarm
  id displayActions;
  id displaySchedule;
  unsigned j;
  float *inp, *oldOut, *out;	// Generic input vector
  
  BLTGraph  *wgtGraph, *attrGraph;
  GraphElement  *wgtData, *ptData, *attrData;
  
  // Initialize swarm
  initSwarm( argc, argv);
  
  aEntry=[Entry create: globalZone];
  [aEntry linkVariable: &numNeurons Type: TCL_LINK_INT];
  [aEntry pack];
  aLabel = [Label createParent:[aEntry getParent]];
  [aLabel setText: "Number of neurons" ];
  [aLabel pack];

  // Create Graph
  wgtGraph = [ BLTGraph create: globalZone];
  [wgtGraph setWidth: WIDTH Height: HEIGHT];
  [wgtGraph setRangesXMin: -1.5 Max:1.5 YMin:-1.5 Max :1.5];
  [wgtGraph title: "Activation wandering" ];
  [wgtGraph axisLabelsX: "neuron 0" Y: "neuron 1"];
  
  // lines and points
  ptData = [wgtGraph createElement];
  [ptData setLabel: "Latest Value" ];
  [ptData setColor: "Blue"];
  [ptData setSymbol: "diamond"];  
  wgtData = [wgtGraph createElement];
  [wgtData setLabel: "Activation" ];
  [wgtData setColor: "Red"];
  [wgtGraph pack];
  
  // Attractor graph
  attrGraph = [ BLTGraph createParent: [wgtGraph getParent]];
  [attrGraph setWidth: WIDTH Height: HEIGHT];
  [attrGraph title: "Attractors" ];
  [attrGraph axisLabelsX: "neuron 0" Y: "neuron 1"];
  
  attrData = [attrGraph createElement];
  [attrData setLabel: "Attractors" ];
  [attrData setColor: "Green"];
  [attrData setSymbol: "scross"];
  [attrGraph pack];
  
  // actions and controlpanel
  controlPanel = [ControlPanel create: globalZone];
  [controlPanel waitForControlEvent];
  
  // MODIFY: schedule display objects here.
  displayActions = [ActionGroup create: globalZone];
  [displayActions createActionTo: controlPanel message: M(doTkEvents)];
  displaySchedule = [Schedule createBegin: globalZone];
  [displaySchedule setRepeatInterval: 1];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  // Neural network
  neura = [CRNN createBegin: globalZone];
  [neura setNumberNeurons: numNeurons ]; 
  [neura setRandomWeights];
  if ( ! (neura = [neura createEnd])  )
    [InvalidCombination raiseEvent: "NN not created"]; // Neural network created

  // Loop variables
  inp = (float*) calloc( numNeurons, sizeof(float));
  oldOut = (float*) calloc( numNeurons, sizeof(float));
  out = (float*) calloc( numNeurons, sizeof(float));

  while ( [controlPanel getState] !=  ControlStateQuit) {
   
    while(  [controlPanel getState] != ControlStateRunning ) {
      Tk_DoOneEvent(0);
    }
    while( Tk_DoOneEvent(TK_ALL_EVENTS|TK_DONT_WAIT))
            ;

    for ( j = 0 ; j < numNeurons; j ++ ) {
      inp[j] = (float)[uniformDblRand getDoubleWithMin:-1.0L withMax: 1.0L] ;
    }

    // Clamp initial values
    [neura clamp: inp];
    [neura getActivation: out];

    // Clamp to 0 and loop
    for ( j = 0 ; j < numNeurons; j ++ ) {
      inp[j] = 0.0;
    }
    [neura clamp: inp];
    while ( (oldOut[0]!= out[0]) && (oldOut[1] != out[1] ) ) {
      [ptData resetData];
      for ( j = 0 ; j < numNeurons; j ++ ) {
	oldOut[j] = out[j];
      }
      [ptData addX: out[0] Y: out[1] ];
      [wgtData addX: out[0] Y: out[1] ];
      [neura getActivation: out];
    }

    //	[wgtGraph destroyElement: wgtData];  
    wgtData = [wgtGraph createElement];
    [wgtData setLabel: "" ];
    [wgtData setColor: "Red"];

    // Plot attractors
    [attrData addX: out[0] Y: out[1] ];
    
  }
  free(inp);
  free(out);
  free(oldOut);
}




