// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.


#include "SOMplus.h"

#include <math.h>

@implementation SOMplus

-setAlpha: (float) a Mult: (float) am {
   alphaInit = alpha = a;
   alphaMult = am;
   return self;
}

-setSelfOrg: (unsigned) steps{ 
   selfOrg = steps; thisTime = 0;
   return self;
}

-setInitialNHood: (unsigned) i {
  initialNHood = nowNHood = i;
  return self;
}

//------------------------------------------------------
-            train: (float) _dummy {
// Winning neuron and neighborhood are changed, delta is 
// not used

    int i, j, start, end;

    // Compute neighborhood
    if ( thisTime < selfOrg ) {
	nowNHood = initialNHood - thisTime*1.0*(initialNHood - 1)/selfOrg;
    } else {
	nowNHood = 1;
    }
	
    end = ((lastWinner+nowNHood) < numNeurons )?
	lastWinner + nowNHood: numNeurons-1;
    start =  (( lastWinner - nowNHood ) > 0)?(lastWinner -nowNHood):0;

    for ( i = start; i <= end;i++ ) {
	for ( j = 0; j < inpSize; j++ ) {
	    Wgts[i *inpSize + j ]+= 
		alpha*(inpLy[j] - Wgts[i*inpSize + j ]);
	}
    }

    // Actualize alpha
    if ( thisTime < selfOrg ) {
	alpha = alphaInit - (thisTime*0.9*alphaInit)/selfOrg;
				// In the selfOrganizing phase, lineal
    } else {
	alpha *= alphaMult;
    }
    
    thisTime++;
    return self;
}

@end
