// Copyright (C) 1995 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

// -*- mode: objc; c-indent-level: 4; comment-column: 35 -*-

// This version 2 attempts compatibility with Swarm

// Version 3 starts to use graphics

// Version 4 uses forms

// Version kkheb2ly es igual, pero para una hebbiana de dos capas...

// Now compiles cleanly for swarm version 0807

// kkcl.m es una adaptacion, para probar CompLearning

#import <simtools.h>
#import <random.h>
#import <simtoolsgui.h>
#import <gui.h>

#import "Hebb2Layer.h"
#import "CompLearning.h"

#include <misc.h>

#define INPUTSIZE 2
#define OUTPUTSIZE 2

#define STEPS 1000

#define RESET_FREQUENCY 10

double alpha = 0.1;
double beta = 0.0; // only used in Hebb case
int nnType = 0;
int numNeurons = 10;
int numClasses = OUTPUTSIZE;

// SimParameters * simParameters;

void doForm();

char *Colors[] = {
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
};

int
main (int argc, const char **argv)
{
  id neura;			// Neural network
  unsigned i,j, error;
  float inp[INPUTSIZE];	// Generic input vector
  id <Graph> errorGraph, wgtGraph;
  id <GraphElement> errorData;
  id <GraphElement> *wgtData;
  id <GraphElement> inpData;
  char Labels[10];
  id <ActionCache> actionCache;
  id <ControlPanel> controlPanel;
  int output;
  
  // Initialize swarm
  initSwarm (argc, argv);
  
#if 0
  doForm();
#endif
  
  if (nnType)
    {		   // Hebb with 2 layers
      neura = [Hebb2Layer createBegin: globalZone];
      [neura setLayerSize: INPUTSIZE: numNeurons: numClasses]; 
      [neura setTrainingConstant: alpha : beta];
    }
  else
    {
      neura = [CompLearning createBegin: globalZone];
      [neura setLayerSize: INPUTSIZE: numNeurons]; 
      [neura setTrainingConstant: alpha];
      [neura setClasses: numClasses];
      [neura setOrderedLabels];
    }
  [neura setRandomWeights];
  neura = [neura createEnd];

  if (neura == NULL)
    [InvalidCombination raiseEvent: "Neural network not created"];
  
  // Create Graph
  errorGraph = [Graph create: globalZone];
  [errorGraph setTitle: "Error" ];
  [errorGraph setAxisLabelsX: "Time" Y: "Error"];
  [errorGraph packFill];
  sprintf (Labels, "Error");
  errorData = [errorGraph createElement];
  [errorData setLabel: Labels ];
  [errorData setColor: "blue"];
  
  // Create Graph
  // wgtGraph = [Graph createParent: [errorGraph getParent]];
  wgtGraph = [Graph create: globalZone];
  [wgtGraph setTitle: "Weight Wandering" ];
  [wgtGraph setAxisLabelsX: "WeightX" Y: "WeightY"];
  // [wgtGraph setScaleModeX: 1 Y: 1]; // "Loose" mode
  [wgtGraph packFill];
  wgtData = (id <GraphElement> *)xmalloc (numNeurons * sizeof (id <GraphElement>));
  for (j = 0; j < numNeurons; j++)
    {
      sprintf (Labels, "Weights %d", j);
      wgtData[j] = [wgtGraph createElement];
      [wgtData[j] setLabel: Labels ];
      [wgtData[j] setColor: Colors[j]];
      [wgtData[j] setSymbol: "diamond"];
    }
  inpData =  [wgtGraph createElement];
  [[[inpData setLabel: "Input"] setColor: "Purple"] setSymbol: "circle"];
  
  // actions and controlpanel
  controlPanel = [ControlPanel create: globalZone];
  // create the actionCache, we will initialize it in activateIn
  actionCache = [ActionCache createBegin: globalZone];
  [actionCache setControlPanel: controlPanel];
  actionCache = [actionCache createEnd];

  i = 0; error = 0;
  while ([controlPanel getState] !=  ControlStateQuit)
    {
      while ([controlPanel getState] != ControlStateRunning)
        [actionCache waitForControlEvent];

      [actionCache deliverActions];     
      [actionCache doTkEvents];
      
      for (j = 0; j < INPUTSIZE; j++)
        inp[j] =  (float)[uniformDblRand getDoubleWithMin:-1.0L withMax: 1.0L];
      
      // x > 0 == class 0; x <= 0 class 1
      
      if (i % RESET_FREQUENCY == 0)
        [inpData resetData];
      [inpData addX:  inp[0] Y: inp[1]];
      output = [neura feedForward: inp];
      //	printf( "Input %f %f Output %d\n", inp[0], inp[1], output );
      if ((( output == 0) && (inp[0] > 0)) // Two classes >0 and <= 0
          || ((output == 1) && (inp[0] <= 0)))
        [neura train: 1];
      else
        {
          error++;
          [neura train: -1 ];
        }
      
      for (j = 0; j < numNeurons; j++)
        {
          float w1, w2;

          if (i % RESET_FREQUENCY == 0)
            [wgtData[j] resetData];
          if (nnType)
            {
              w1 = [neura getWeights: 0: j: 0 ];
              w2 =  [neura getWeights: 0: j: 1 ];
	    }
          else
            {
              w1 = [neura getWeights: j: 0 ];
              w2 =  [neura getWeights: j: 1 ];
	    }
          [wgtData[j] addX:  w1 Y: w2 ];
	}
      
      {
        float yValue = error * 1.0 / (i + 1);

        [errorData addX: i Y: yValue];
      }
      i++;
    }
  exit (0);
}


// this is the current mechanism for setting simulation parameters.
// it will be changed when experiment objects are written.
#if 0
void
doForm ()
{
#define NUMPARAMETERS 4
  Parameter p[NUMPARAMETERS] = {
    {"Number of output/hidden neurons", &numNeurons, TCL_LINK_INT},
    {"Training Parameter alpha", &alpha, TCL_LINK_DOUBLE},
    {"Training Parameter beta", &beta, TCL_LINK_DOUBLE},
    {"Check for Hebb2Layer ", &nnType, TCL_LINK_BOOLEAN}
  };
  
  simParameters = [SimParameters createBegin: globalZone];
  [simParameters setParameterList: p Num: NUMPARAMETERS];
  if ( !( simParameters = [simParameters createEnd]))
    [InvalidCombination raiseEvent: "La jodiste" ];
  [simParameters readValues: simControl];
}
#endif

