// Copyright (C) 1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.


#ifndef __BASESINGLELAYER_H
#define __BASESINGLELAYER_H

#include "neuron.h"		// Protocol for neurons

// Abstract base class for SingleLayer neural networks. Shouldn't
// be used standalone, must inherit from int.

@interface BaseSingleLayer: SwarmObject <NN, Unsupervised, SingleLayer> { 
    float alpha;
    unsigned inpSize, numNeurons;
    float *inpLy, *Wgts, *opLy;	// Input, Weights and output layer
}

@end

#endif
