// Copyright  1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#include "CompLearning.h"

#include <misc.h>
#include <math.h>

@implementation CompLearning

//--------------------------------------------
// Instance objects, taken from the protocol
- setLayerSize: (unsigned)inpLyUnits: (unsigned)opLyUnits
{

    if (![super setLayerSize: inpLyUnits :opLyUnits])
      {
	[InvalidCombination raiseEvent: 
                              "CompLearning: problems with base class\n" ];
	return nil;
      }
    
    labels = (unsigned *)xcalloc (numNeurons, sizeof (unsigned));
    numClasses = numNeurons;	// Default values

    if (!labels)
      [InvalidCombination raiseEvent: 
                            "Problems with  malloc or network size\n"];
    return self;
}

//--------------------------------------------
- free
{
  [super free];
  xfree (labels);
  return nil;
}

//-----------------------------------------------------
- createEnd
{
  if (![super createEnd])
    [InvalidCombination raiseEvent:
                          "CompLearning Problems with base class\n"];
  
  if (!labels)
    [InvalidCombination raiseEvent:
                          "Problems with  malloc or network size\n"];

  return self;
}

- setClasses: (unsigned)c
{
  numClasses = c;
  return self;
}

- setOrderedLabels
{
  unsigned i;
  if (numClasses)
    for (i = 0; i < numNeurons; i++) 
      labels[i] = i % numClasses;
  return self;
}

//-----------------------------------------------------
//            Learning and recalling functions
//-----------------------------------------------------

//-----------------------------------------------------
- (unsigned)feedForward: (float *)inpVec
{
  // dimension should be the same than the input layer
  return labels[[super feedForward: inpVec]];
}


//------------------------------------------------------
- train: (float)delta
{
  // Winning neuron and neighborhood are changed
  int j;
  
  for ( j = 0; j < inpSize; j++ )
    Wgts[lastWinner * inpSize + j] += 
      delta * alpha * (inpLy[j] - Wgts[lastWinner*inpSize + j]);

  return self;
}

@end
