// Copyright (C) 1995-1999 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#include "ObserverSwarm.h"
#include "ModelSwarm.h"

int displayFrequency = 1;

@implementation ObserverSwarm

- buildObjects
{
  [super buildObjects];

  modelSwarm = [ModelSwarm create: self];
  [modelSwarm buildObjects];
  return self;
}

- buildActions
{
  [super buildActions];
  
  displayActions = [ActionGroup create: self];
  [displayActions createActionTo: modelSwarm message: M(updateDisplay)];
  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  
  [displaySchedule at: 0 createAction: displayActions];
  
  return self;
}

- activateIn: swarmContext
{
  [super activateIn: swarmContext];
  
  [modelSwarm activateIn: self];
  [displaySchedule activateIn: self];

  return [self getActivity];
}

@end

