// 	$Id: BoolNetObserverSwarm.m,v 1.7 1998/01/15 22:03:54 mgd Exp $	

#import "BoolNetObserverSwarm.h"
#import "BoolNetModelSwarm.h"
#import <collections.h>
#import <swarmobject.h>

@implementation BoolNetObserverSwarm

// createBegin: here we set up the default observation parameters.
+createBegin: (id) aZone {
  BoolNetObserverSwarm * obj;
  id <ProbeMap> probeMap;
  
  obj = [super createBegin: aZone];

  obj->displayFrequency = 1;
  obj->interactiveGraph = 1;

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
   				    inClass: [self class]]];

  [probeMap addProbe: [probeLibrary getProbeForVariable: "interactiveGraph"
   				    inClass: [self class]]];

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

-createEnd {
  return [super createEnd];
}

-buildObjects {
  id modelZone;	

  [super buildObjects];

  modelZone = [Zone create: [self getZone]];
  boolNetModelSwarm = [BoolNetModelSwarm create: modelZone];
  
  // Now create probe objects on the model and ourselves. This gives a
  // simple user interface to let the user change parameters.
  CREATE_ARCHIVED_PROBE_DISPLAY (boolNetModelSwarm);
  CREATE_ARCHIVED_PROBE_DISPLAY (self);

  [controlPanel waitForControlEvent];
  if ([controlPanel getState] == ControlStateQuit)
     return self;

  if(interactiveGraph) {
    graphCanvas = [Canvas createBegin: [self getZone]] ;
    SET_WINDOW_GEOMETRY_RECORD_NAME (graphCanvas);
    graphCanvas = [graphCanvas createEnd];
    
    [[graphCanvas setHeight: 500] setWidth: 500] ;
    [graphCanvas setWindowTitle: "The Boolean network"] ;
    
    [globalTkInterp eval: 
      "pack %s -expand 1 -fill both ; update idletasks", 
      [graphCanvas getWidgetName]] ;
  }
 
  [boolNetModelSwarm setGraphCanvas: graphCanvas] ;
  [boolNetModelSwarm buildObjects];

  return self;
}  

-buildActions {
  [super buildActions];
  
  [boolNetModelSwarm buildActions];
  
  displayActions = [ActionGroup create: [self getZone]];

  [displayActions createActionTo: probeDisplayManager message: M(update)];
  [displayActions createActionTo: actionCache         message: M(doTkEvents)];

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency];
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];

  return self;
}  

-activateIn: (id) swarmContext {

  [super activateIn: swarmContext];

  [boolNetModelSwarm activateIn: self];

  [displaySchedule activateIn: self];

  return [self getSwarmActivity];
}

// You could override the "go" method here if you want something special
// to happen when the model and observer actually start running. But
// the default GUISwarm go is probably good enough.

@end
