// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************

// ModelSwarm.m 

#import "ModelSwarm.h"

@implementation ModelSwarm  

+ createBegin: aZone 
{
  ModelSwarm *obj;
  id <ProbeMap> probeMap;

  // in createBegin, we set up the simulation parameters

  // first, call our superclass createBegin - the return value is the
  // allocated Swarm object.

  obj = [super createBegin: aZone];

  // now fill in simulation parameters with default values.

  obj-> useEO_EP                           =  0;

// ++++++++ start
  obj-> agentNumber                        =  1;
  obj-> inputNodeNumber                    =  2;
  obj-> hiddenNodeNumber                   =  4;
  obj-> outputNodeNumber                   =  2;
// +++++++ end

  obj-> patternNumberInVerificationSet     = -1;
  obj-> patternNumberInTrainingSet         = -1;
  obj-> epochNumberInEachTrainingCycle     =  1;
  obj-> agentsAreDisplayingData            =  1;
  obj-> readWeightsFromFile                =  0;
  obj-> epochGroups                        =  0;

  // build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the format of the probe to give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "useEO_EP"         inClass: [self class]]];

// +++++++ start
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "agentNumber"      inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "inputNodeNumber"  inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "hiddenNodeNumber" inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "outputNodeNumber" inClass: [self class]]];
// +++++++ end

  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "patternNumberInVerificationSet"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "patternNumberInTrainingSet"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "epochNumberInEachTrainingCycle"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "epochGroups"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "agentsAreDisplayingData"
                                           inClass: [self class]]];
  [probeMap addProbe: [probeLibrary
   getProbeForVariable: "readWeightsFromFile"
                                           inClass: [self class]]];

  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];
  
  return obj;
}

- createEnd
{
  return [super createEnd];
}


- buildObjects
{
// +++++++ start
  Agent *anAgent;
  SpecificInterface * anInterface;
// +++++++ end

  DataWarehouse * aDataWarehouse;


  int i;

// +++++++ start
  char * verificationFileName="data.verification", // the name of this file
                                                   // can be kept unchanged
                                                   // also when the file
                                                   // contents are modfied
                                                   // or the file is deleted,
                                                   // as in CT

       * trainingFileName    ="data.training",     // (see above)

       * minmaxFileName      ="minmax.data",       // mandatory, one for each
                                                   // agent (or neural n.)
                                                   // type

       * initValuesFileName  ="init.val";          // this file is used only
                                                   // with internal data
                                                   // generation (CT scheme)
                                                   // but anyway the existence
                                                   // of the file is not
                                                   // mandatory
// +++++++ end

  // to check whether using Cross Target (CT) option, i.e.  
  //                                  patternNumberInVerificationSet < 0 and
  //                                  patternNumberInTrainingSet < 0

  if (patternNumberInVerificationSet < 0 && patternNumberInTrainingSet < 0)
                            printf("\n\nUsing Cross Target technique!\n\n"); 

  if (patternNumberInVerificationSet < 0 &&
      patternNumberInVerificationSet != -1)
      {
  printf("\n(In this case the patternNumberInVerificationSet must be -1).\n\n"
       );
       exit(0);
      }

  if ((patternNumberInVerificationSet < 0 && patternNumberInTrainingSet > 0) ||
      (patternNumberInVerificationSet > 0 && patternNumberInTrainingSet < 0))
      {
       printf(
  "\n\nCheck the signs of\n\n"
  "patternNumberInVerificationSet and patternNumberInTrainingSet.\n\n");
       exit(0);
      }

  if (patternNumberInVerificationSet == 0 ||
      patternNumberInTrainingSet == 0   )
      {
       printf(
  "\n\nIllegal zero in patternNumberInVerificationSet "
  "or in patternNumberInTrainingSet.\n\n");
       exit(0);
      }

  // here, we create the objects in the model
  
  // here we create an instance of MatrixMult, VectorTransFunc
  // and of RuleMaster-RuleMaker

  matrixMult = [MatrixMult createBegin: self];
  matrixMult = [matrixMult createEnd];

  transFunc = [TransFunc createBegin: self];
  transFunc = [transFunc createEnd];

  vectorTransFunc = [VectorTransFunc createBegin: self];
  vectorTransFunc = [vectorTransFunc setTransFunc: transFunc];
  vectorTransFunc = [vectorTransFunc createEnd];

  // using artificial neural networks, we have here the learning structure
  // (ruleMaker) and the pure forward step (ruleMaster)

  ruleMaker = [RuleMaker createBegin: self];
  [ruleMaker setMatrixMult: matrixMult];
  [ruleMaker setVectorTransFunc: vectorTransFunc];
  ruleMaker = [ruleMaker createEnd];

  ruleMaster = [RuleMaster createBegin: self];
  [ruleMaster setRuleMaker: ruleMaker];
  [ruleMaster setMatrixMult: matrixMult];
  [ruleMaster setVectorTransFunc: vectorTransFunc];
  ruleMaster = [ruleMaster createEnd];

  // default backpropagation parameters

  weightRange  =0.3;
  eps          =0.6;
  alpha        =0.9;
  usingRandomOrderInLearning =1;
  longTermLearningInCT_OnlyWithCompleteTrainingSet =1;
  useOutputsAsTargetsInCT_RelearningScheme =0;

  [ObjectLoader load: self fromFileNamed: "bp.setup"];

// +++++++ start
  // we create a tool to shufle the lists
  //listShuffler = [ListShuffler createBegin: self];
  //listShuffler = [listShuffler createEnd];
// +++++++ end

  // now, we create the agents


// +++++++ start
  agentList  = [List  create: self];
  agentArray = [Array create: self];
  if(agentNumber>0)
    [agentArray setCount: agentNumber];
  agentArrayIndex = [agentArray begin: self];

  for (i=1;i<=agentNumber;i++){


  // first we create the datawarehouse where agent technical data are stored
  aDataWarehouse= [DataWarehouse createBegin: self];
  [aDataWarehouse setVerificationFileName: verificationFileName
                  andTrainingFileName: trainingFileName
                  andMinmaxName: minmaxFileName
                  andInitValuesFileName: initValuesFileName];
  [aDataWarehouse setInputNodeNumber:  inputNodeNumber
                  andHiddenNodeNumber: hiddenNodeNumber
                  andOutputNodeNumber: outputNodeNumber
           andPatternNumberInVerificationSet: patternNumberInVerificationSet
           andPatternNumberInTrainingSet:     patternNumberInTrainingSet
           andEpochNumberInEachTrainingCycle:
                                       epochNumberInEachTrainingCycle];
  [aDataWarehouse setBackPropagationParametersWeightRange: weightRange
                  eps: eps alpha: alpha
                  andWithOrderInLearning: usingRandomOrderInLearning
                  andLongTermLearningInCT:
                  longTermLearningInCT_OnlyWithCompleteTrainingSet
                  andUseOutputsAsTargetsInCT:
                  useOutputsAsTargetsInCT_RelearningScheme];

  aDataWarehouse=[aDataWarehouse createEnd];

  // then we create an interface for our agent, to simplifly its links
  // with the observer, if any, but mainly as a help in CT building

  anInterface = [SpecificInterface createBegin: self];
  [anInterface setUseEO_EP: useEO_EP];
  [anInterface setAgentNumber: i];
  [anInterface setDataWarehouse: aDataWarehouse];
  anInterface = [anInterface createEnd];
  [anInterface initialize]; // NB. after createEnd

  anAgent = [Agent createBegin: self];
  [anAgent setNumber: i andSetReadWeightsFromFile: readWeightsFromFile];
  [anAgent setDataWarehouse: aDataWarehouse];
  [anAgent setInterface: anInterface];
  [anAgent setRuleMaster: ruleMaster];
  [anAgent setDisplayDataWhileRunning: agentsAreDisplayingData];
  anAgent = [anAgent createEnd];
  [agentList addLast: anAgent];

  [agentArrayIndex next];
  [agentArrayIndex put: anAgent];
// +++++++ end

   }
  return self;
}

- buildActions
{
  // we create the list of simulation actions

  modelActions = [ActionGroup create: self];
// +++++++ start
  // see agent.h and agent.m to undestand the rigid three step structure
  [modelActions createActionForEach: agentList    message: M(step1)];
  [modelActions createActionForEach: agentList    message: M(step2)];
  [modelActions createActionForEach: agentList    message: M(step3)];
// +++++++ end
  [modelActions createActionTo: self message: M(currentEpochGroups)];

  // then we create a schedule that executes the modelActions.

  modelSchedule = [Schedule createBegin: self];

  // the "if" condition is related to the CT use of the program
  if (patternNumberInVerificationSet < 0)
  [modelSchedule setRepeatInterval: -1*patternNumberInVerificationSet];
  else
  [modelSchedule setRepeatInterval:    patternNumberInVerificationSet];  
                 // the repeat interval is set to the number of steps which is
                 // necessary in the Observer to display the values of each
                 // pattern of an agent in each cycle
                 // here patternNumberInVerificationSet-1 steps are void
  modelSchedule = [modelSchedule createEnd];
  [modelSchedule at: 0 createAction: modelActions]; 

  return self;
}

- activateIn: swarmContext
{
  // here, we activate the swarm in the context passed in
  // then we activate our schedule in ourselves

  [super activateIn: swarmContext];

  [modelSchedule activateIn: self];
  
  
  return [self getSwarmActivity];
}

- (int) currentEpochGroups
{
  epochGroups++;
//  printf("Epoch group #%5d\n",epochGroups);
  return epochGroups;
}

- (int) getCurrentEpochGroup
{
  return epochGroups;
}

- (int) getPatternNumberInVerificationSet
{
  return patternNumberInVerificationSet;
}

- (int) getAgentNumber
{
  return agentNumber;
}

- getList
{
  return agentList;
}

- getAgentArrayIndex
{
  return agentArrayIndex;
}

@end
