// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************
//
// the files ConsumerInterface.h and ProducerInterface.h correspond to the
// file SpecificInterface.h in the master ct-bp code
//
// in SpecificInterface.h we read:
// in apps we have to prepare a XXXInterface.h file for each type of agent:
// in the accompanying ct-hayek application of bp-ct this file corresponds
// to the files ConsumerInterface.h and ProducerInterface.h
//
// **********************************

// ConsumerInterface.h 

#import "Interface.h" // see headers imported by Interface.h

@interface ConsumerInterface: Interface
{

// we need a variable nX for each input and a variable nX_out and nX_target
// for each output
// X is the conventional name that we use to identify the specific input
// or output; the use of this kind of variables is explained in the
// related .m file

// +++++++ start
  float  nExpenditure0, nRequirement0, nP0, nQ0,
         nActualP_out   , nActualQ_out   , nExpenditure_out   ,
         nRequirement_out   , nP_out   , nQ_out   ,
         nActualP_target, nActualQ_target, nActualQ_target_devidedBy10,
         nExpenditure_target, nRequirement_target,
         nP_target, nQ_target;

  id <Index> producerListIndex;

  // CT variables
  float correction, correction1, correction2,
        myP, aProducerP, actualP_target,
        myQ, aProducerQ, actualQ_target,
        expenditure_target, expenditure0,
        expenditure_out, expenditureEO_target,
        requirement_target, actualRequirement, requirementEO_target,
        requirement_out,
        p_target,
        q_target;
// +++++++ end

}

  // the following methods are strictly related to the meaning the problem
  // data to which we are applying our neural network have


  // so, for each application, we have to modify them if we want to display
  // agent data or operate with them in a CT way

// +++++++ start
- (float)getExpenditure0;
         // Expenditure0 is the first  input in the 'ct-hayek' application
- (float)getRequirement0;
         // Requirement0 is the second input in the 'ct-hayek' application
- (float)getP0;
         // P0           is the third  input in the 'ct-hayek' application
- (float)getQ0;
         // Q0           is the fourth input in the 'ct-hayek' application

- (float)getActualP_out;
         // ActualP_out     is the first  output in the 'ct-hayek' application
- (float)getActualP_target;
         // ActualP_target  is the first  target in the 'ct-hayek' application
- (float)getActualQ_out;                 
         // ActualQ_out     is the second output in the 'ct-hayek' application
- (float)getActualQ_target;
         // ActualQ_target  is the second target in the 'ct-hayek' application
- (float)getActualQ_target_devidedBy10;
         // ActualQ_target  is the second target in the 'ct-hayek' application
- (float)getExpenditure_out;                 
         // Expenditure_out is the third  output in the 'ct-hayek' application
- (float)getExpenditure_target;
         // Expenditure_target
         //                 is the third  target in the 'ct-hayek' application
- (float)getRequirement_out;                 
         // Requirement_out is the fourth output in the 'ct-hayek' application
- (float)getRequirement_target;
         // Requirement_target
         //                 is the fourth target in the 'ct-hayek' application
- (float)getP_out;
         // P_out           is the fifth  output in the 'ct-hayek' application
- (float)getP_target;
         // P_target        is the fifth  target in the 'ct-hayek' application
- (float)getQ_out;
         // Q_out           is the sixth  output in the 'ct-hayek' application
- (float)getQ_target;
         // Q_target        is the sixth  target in the 'ct-hayek' application
// +++++++ end

  // the following methods override those of Interface.h, which
  // are left void in Interface.m

- initialize;

- setProducerListIndex: pli;
- setCT_Inputs;
- setCT_Targets;

@end
