// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************
//
// the files ConsumerInterface.m and ProducerInterface.m correspond to the
// file SpecificInterface.m in the master ct-bp code
//
// in SpecificInterface.m we read:
// in apps we have to prepare a XXXInterface.m file for each type of agent:
// in the accompanying ct-hayek application of bp-ct this file corresponds
// to the files ConsumerInterface.m and ProducerInterface.m
//
// **********************************

// ConsumerInterface.m                                        

#import "ConsumerInterface.h"

// +++++++ start
#import "BPCTAgent.h" // used below to look at a producer
#import "ProducerInterface.h" // used below to look at a producer
// +++++++ end

@implementation ConsumerInterface

  // all data are considered here in their external metrics; all the job
  // of tranforming the external metrics to the internal one (useful for
  // a neural netowrk) and then to the external one again is done
  // automatically using the various matrixes, which are contained in objects
  // that respond to the ...asExternal... methods, which apply the internal
  // and external min-max intervals contained in the minmax matrix

  // the following methods are strictly related to the meaning the problem
  // data to which we are applying our neural network have

  // so we have to modify them whemever we change the problem if we want
  // to display agent data or operate with them in a CT way

  // the following "get" methods link the external names (used by the model
  // builder as variables) to the inputs/outputs/targets of the neural
  // network, where they are identified by a position in the input, output,
  // target vectors

// +++++++ start
- (float)getExpenditure0
         // Expenditure0 is the first  input of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  // in each "get" we access a different pattern, as in a loop,
  // restarting from the first at the end (we use here the remainder of
  // the integer quotient calculated below with the % or Mod operator)

  // the mechanism for counting by 0.5 is expalined in SpecificInterface.m
  // in the parent code bp-ct

  k = nExpenditure0;
  nExpenditure0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                           withShift: 0];
  // withShift: 0 means no shift, because minmax (row) position
  // matches perfectly dataVerificationMatrix (col) position
}

- (float)getRequirement0
         // Requirement0 is the second input of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nRequirement0;
  nRequirement0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                           withShift: 0];
}

- (float)getP0
         // P0           is the third  input of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nP0;
  nP0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 2 asExternalValueUsing: minmax
                                           withShift: 0];
}

- (float)getQ0
         // Q0           is the fourth input in the 'ct-hayek' application
{
  int k;
  k = nQ0;
  nQ0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 3 asExternalValueUsing: minmax
                                           withShift: 0];
}

- (float)getActualP_out
         // ActualP_out     is the first   output of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualP_out;
  nActualP_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
  // withShift: inputNodeNumber matches minmax (row)
  // position and outputVerificationMatrix (col) position
  // (we have to use it here in all "get" methods that are related
  // to outputs or targets)
}

- (float)getActualP_target
         // ActualP_target  is the first   target of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualP_target;
  nActualP_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
  // withShift: inputNodeNumber matches minmax (row)
  // position and targetVerificationMatrix (col) position
  // (we have to use it here in all "get" methods that are related
  // to outputs or targets)
}

- (float)getActualQ_out
         // ActualQ_out     is the second  output of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualQ_out;
  nActualQ_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getActualQ_target
         // ActualQ_target  is the second  target of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualQ_target;
  nActualQ_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getActualQ_target_devidedBy10
         // ActualQ_target  is the second  target of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualQ_target_devidedBy10;
  nActualQ_target_devidedBy10+=0.5;
  k = k % patternNumberInVerificationSet;

  return 0.1*[targetVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}
- (float)getExpenditure_out
         // Expenditure_out is the third   output of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nExpenditure_out;
  nExpenditure_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 2 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getExpenditure_target
         // Expenditure_target
         //                 is the third   target of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nExpenditure_target;
  nExpenditure_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 2 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getRequirement_out
         // Requirement_out is the fourth  output of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nRequirement_out;
  nRequirement_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 3 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getRequirement_target
         // Requirement_target
         //                 is the fourth  target of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nRequirement_target;
  nRequirement_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 3 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getP_out
         // P_out           is the fifth   output of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nP_out;
  nP_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 4 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getP_target
         // P_target        is the fifth   target of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nP_target;
  nP_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 4 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getQ_out
         // Q_out           is the sixth   output of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nQ_out;
  nQ_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 5 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getQ_target
         // Q_target        is the sixth   target of a Consumer in the
         // 'ct-hayek' application
{
  int k;
  k = nQ_target;
  nQ_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 5 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}
// +++++++ end

- initialize 
{
  int i;
  int outputNodeNumber;
  outputNodeNumber=[myAgentDataWarehouse getOutputNodeNumber];

  // counter initialization (strictly related to our application)

// +++++++ start
  nExpenditure0=0; nRequirement0=0; nP0=0; nQ0=0;
  nActualP_out   =0; nActualQ_out   =0; nExpenditure_out   =0;
  nRequirement_out   =0; nP_out   =0; nQ_out   =0;
  nActualP_target=0; nActualQ_target=0; nActualQ_target_devidedBy10=0;
  nExpenditure_target=0;
  nRequirement_target=0; nP_target=0; nQ_target=0;
// +++++++ end

  // the counter mechanism works in the following way
  // the Observer gets the values via one of the methods reported above;
  // the counter is increased twice a cycle (with a step of 0.5, giving 1),
  // because the Observer display widget (which is also reporting data
  // in a file) makes two calls to the method

  // the integer remainder obtained dividing the counter
  // by the number of the patterns, lays always between 0 and
  // patternNumberInVerificationSet-1

  // in the CT case the number of calls can be odd, due to the interface
  // calls used to build targets: in this case, anyway,
  // patternNumberInVerificationSet is equal to -1 and the result of
  // k % patternNumberInVerificationSet is always 0

  // the following lines are useful only in CT scheme if we look (via get...)
  // for initial values in outputVerificationMatrix (initial values are
  // stored in dataTrainingMatrix via DataWarehouse createEnd method)

  for (i=0;i<outputNodeNumber;i++)
  [outputVerificationMatrix R:0 C: i setFrom:
                            [dataTrainingMatrix R:0 C: i+inputNodeNumber]];

  return self;
}

// +++++++ start
// special method of this Consumer agent
- setProducerListIndex: pli
{
  producerListIndex = pli;
  return self;
}
// +++++++ end

- setCT_Inputs
{

  // preserving previuously generated data, in CT scheme
  // when abs(patternNumberInTrainingSet)>1 ;
  // if abs(patternNumberInTraingingSet)=1 'shift' returns without effects
  [dataTrainingMatrix shift];

  // inputs:
  // we have to provide inputs (the same) both to the
  // dataVerificationMatrix (used in the no-learning acting phase in CT)
  // and to the dataTrainingMatrix (used in learning phase)

  // the learning phase uses one or more patterns and may be repeated in
  // each step (see the HowToUseBp-Ct.txt in the bp-ct package)
  // we store the data always in dataTrainingMatrix last row; the shift
  // order done above assures that the line is free and previous data are
  // preserved

// +++++++ start
  // input values come from the same agent outputs in the previous
  // cycle or action day (the get... messages are sent to self, i.e. the agent)
  // in the first cycle or action day data come from initial values

  // Expenditure0
  [dataVerificationMatrix R:0      C:0 setFrom: [self getExpenditure_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:0 setFrom: [self getExpenditure_out]
                                  asExternalValueUsing: minmax withShift: 0];

  // Requirement0
  [dataVerificationMatrix R:0      C:1 setFrom: [self getRequirement_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:1 setFrom: [self getRequirement_out]
                                  asExternalValueUsing: minmax withShift: 0];

  // P0
  [dataVerificationMatrix R:0      C:2 setFrom: [self getP_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:2 setFrom: [self getP_out]
                                  asExternalValueUsing: minmax withShift: 0];

  // Q0
  [dataVerificationMatrix R:0      C:3 setFrom: [self getQ_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:3 setFrom: [self getQ_out]
                                  asExternalValueUsing: minmax withShift: 0];
// +++++++ end
  
  return self;
}

- setCT_Targets
{

// +++++++ start
  // looking to an other agent, here a producer agent, in a shuffled list
  // this is a specific solution for this ct-hayek application
  BPCTAgent * aProducer;
  // its interface
  ProducerInterface * aProducerInterface; 

  aProducer = [producerListIndex next];   // the list is shuffled in each
                                          // cycle or day
  aProducerInterface = [aProducer getInterface];
// ++++++ end


  // NB. A general rule: IF WE NEED TO USE OTHER AGENTS OUTPUTS TO
  // GENERATE TARGETS WE MUST MANDATORYLY REFER TO OUTPUTS IN THE VERIFICATION
  // SET; we observe automatically this general rule if we build the getXXX
  // methods in interface objects as it is done in the introductory packages
  // bp-ct and ct-hayek, i.e. always getting inputs, outputs and targets
  // from the verification matrixes and - obviously - if we access values
  // only by means of those getXXX methods (addressed to other agents'
  // interfaces)


  // CT values (*)


// +++++++ start
  // ActualP
  myP            = [self getP_out];
  aProducerP     = [aProducerInterface getP_out]; // the producer has been
                                                  // randomly chosen via the
                                                  // list above
  if(myP >= aProducerP)
  // the producer price is adopted if it is less than the consumer price
  // (the exchange occurs)
  {
  actualP_target = aProducerP;
  [aProducerInterface setActualP_target_via_CT: actualP_target];
  // see the effect in ProducerInterface.m
  }
  else
  // in the opposite case, the consumerPrice is adopted (the exchange fails)
  {
  actualP_target=myP;
  [aProducerInterface setActualP_target_via_CT: myP];
  // see the effect in ProducerInterface.m
  }
  // we constrain the value to lay between the allowed min and max

  if(actualP_target < [minmax R: 4 C: 0])actualP_target=[minmax R:4 C: 0];
  if(actualP_target > [minmax R: 4 C: 1])actualP_target=[minmax R:4 C: 1];

  // having 4 inputs, rows from 0 to 3 of minmax matrix contain
  // their min and max values (external min and max, cols 0 and 1; internal
  // ones, cols 2 and 3)
  // row 4 is related to the first output/target (we could also note
  // 'inputNodeNumber+0' instead of '4')

  // in CT scheme ActualP_target is not arising from the cross target system,
  // being established by confrontation with the price of another agent


  // ActualQ
  myQ            = [self getQ_out];
  aProducerQ     = [aProducerInterface getQ_out];

  if(myP >= aProducerP)
  {
  actualQ_target = myQ;
  if (aProducerQ < myQ) actualQ_target = aProducerQ;
  // the min quantity prevails in the exchange
  [aProducerInterface setActualQ_target_via_CT: actualQ_target];
  // see the effect in ProducerInterface.m
  }
  else
  {
  actualQ_target = 0; // the exchange fails
  [aProducerInterface setActualQ_target_via_CT: actualQ_target];
  // see the effect in ProducerInterface.m
  }
  if(actualQ_target < [minmax R: 5 C: 0])actualQ_target=[minmax R:5 C: 0];
  if(actualQ_target > [minmax R: 5 C: 1])actualQ_target=[minmax R:5 C: 1];

  // see above the notes about actualP


  // this, on the side of the effects, is a CT-like target, based upon
  // actions; the learning process will produce
  // outputs closer and closer to the consequences of the actions
  // Expenditure
  expenditure_target = myP * myQ;
  if(expenditure_target < [minmax R: 6 C: 0])
                                     expenditure_target=[minmax R:6 C: 0];
  if(expenditure_target > [minmax R: 6 C: 1])
                                     expenditure_target=[minmax R:6 C: 1];

  // always on the side of the effects we have here an external objective
  // (EO) as target that, in case, substitutes (see below) the orginal
  // CT target
  expenditure0 = [self getExpenditure0];
  expenditureEO_target = expenditure0 * 0.98;  // EO to reduce expenditure
  if(expenditureEO_target < [minmax R: 6 C: 0])
                                     expenditureEO_target=[minmax R:6 C: 0];
  if(expenditureEO_target > [minmax R: 6 C: 1])
                                     expenditureEO_target=[minmax R:6 C: 1];



  // the Requirement (daily requirement) is simply set equal to the bought
  // quantity (which indirectly is the consequence of actions, so the CT
  // scheme is respected);
  // this effect has been introduced only to use an EO
  requirement_target = actualQ_target;
  if(requirement_target < [minmax R: 7 C: 0])
                                     requirement_target=[minmax R:7 C: 0];
  if(requirement_target > [minmax R: 7 C: 1])
                                     requirement_target=[minmax R:7 C: 1];


  // the EO - if used, see below - is here to keep constant
  // the requirement
  actualRequirement=20;
  requirementEO_target = actualRequirement;
  if(requirementEO_target < [minmax R: 7 C: 0])
                                     requirementEO_target=[minmax R:7 C: 0];
  if(requirementEO_target > [minmax R: 7 C: 1])
                                     requirementEO_target=[minmax R:7 C: 1];


  // P

  // here we have an action, with multiple possible corrections from various
  // effects, strctly in CT scheme

  // NB, in all apps, pay attention to the fact that when we have multiple
  // possible corrections, we have to compare the correction absolute values
  // and not the values of the corresponding action incorporating each
  // possible correction

  // to reduce the difference between expenditure_out and expenditure_target
  // we can modify P or Q (here we divide by myQ, acting on P); to
  // assign a share of the difference to P and the remainder to Q
  // we can use a random separating value in the range 0-1
  // more easily, here we divide the difference by 2
  expenditure_out=[self getExpenditure_out];
  correction1 = ((expenditure_out-expenditure_target)/2.)/myQ;

  // here the correction is determined as a fixed value
  requirement_out=[self getRequirement_out];
  correction2=0;
  if(requirement_out < requirement_target) correction2= -0.15;
  if(requirement_out > requirement_target) correction2=  0.15;

  // we use the max (fabs correctionX); fabs is float abs
  correction = correction1;
  if(fabs(correction2) > fabs(correction))correction=correction2;

  p_target = myP + correction;
  if(p_target < [minmax R: 8 C: 0])p_target=[minmax R:8 C: 0];
  if(p_target > [minmax R: 8 C: 1])p_target=[minmax R:8 C: 1];


  // Q

  // see above the comments about P

  correction1 = ((expenditure_out-expenditure_target)/2.)/myP;

  correction2=0;
//  if(requirement_out < requirement_target) correction2= -2;
//  if(requirement_out > requirement_target) correction2=  2;

  // in this version the following corrections are not used
  correction = correction1;
  if(fabs(correction2) > fabs(correction))correction=correction2;

  q_target = myQ + correction;
  if(q_target < [minmax R: 9 C: 0])q_target=[minmax R:9 C: 0];
  if(q_target > [minmax R: 9 C: 1])q_target=[minmax R:9 C: 1];
// +++++++ end


  // targets

  // the values determined above are reported in the data matrixes, to be
  // used in the verification (acting) and in the training (with or without
  // long term learning) steps

  // the "if" conditions are related to the use of (i) none at all, (ii) a part
  // or (iii) all E0s (EP are absent here; they work on actions, exactly
  // the same way EOs work on effects)

  // NB values that are copied in dataTrainingMatrix are nandatorily sent to the
  // last row, with 'R_lastAndC:' message (remember the [dataTrainingMatrix
  // shift] instruction above, that empties the last row shifting up all
  // patterns)

  // cols positions in matrixes below come from the names-positions
  // definitions made in the getXXX methods in the opening of this file


// +++++++ start
  // ActualP
  [dataVerificationMatrix R: 0     C: 4 
                   setFrom: actualP_target     asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 4
                   setFrom: actualP_target     asExternalValueUsing:
                                               minmax withShift: 0];

  // ActualQ
  [dataVerificationMatrix R: 0     C: 5
                   setFrom: actualQ_target     asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 5
                   setFrom: actualQ_target     asExternalValueUsing:
                                               minmax withShift: 0];

  // Expenditure
  if(useEO_EP==1 || useEO_EP==3)
              {
  [dataVerificationMatrix R: 0     C: 6
                   setFrom: expenditureEO_target asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 6
                   setFrom: expenditureEO_target asExternalValueUsing:
                                               minmax withShift: 0];
              }
  else        {
  [dataVerificationMatrix R: 0     C: 6
                   setFrom: expenditure_target asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 6
                   setFrom: expenditure_target asExternalValueUsing:
                                               minmax withShift: 0];
              }

  // Requirement
  if(useEO_EP==2 || useEO_EP==3)
              {
  [dataVerificationMatrix R: 0     C: 7
                   setFrom: requirementEO_target asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 7
                   setFrom: requirementEO_target asExternalValueUsing:
                                               minmax withShift: 0];
              }
  else        {
  [dataVerificationMatrix R: 0     C: 7
                   setFrom: requirement_target asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 7
                   setFrom: requirement_target asExternalValueUsing:
                                               minmax withShift: 0];
              } 

  // P
  [dataVerificationMatrix R: 0     C: 8
                   setFrom: p_target           asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 8
                   setFrom: p_target           asExternalValueUsing:
                                               minmax withShift: 0];

  // Q
  [dataVerificationMatrix R: 0     C: 9
                   setFrom: q_target           asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 9
                   setFrom: q_target           asExternalValueUsing:
                                               minmax withShift: 0];
// +++++++ end


  return self;
}

@end

// (*) first of all we define the CT targets; then, in a second step (after
// '// targets' comment), we report those values in the requested
// matrixes
