// **********************************
// from basic code to apps: changing lines are delimited with
//                                             // +++++++ start
//                                             // +++++++ end
// **********************************
//
// the files ConsumerInterface.m and ProducerInterface.m correspond to the
// file SpecificInterface.m in the master ct-bp code
//
// in SpecificInterface.m we read:
// in apps we have to prepare a XXXInterface.m file for each type of agent:
// in the accompanying ct-hayek application of bp-ct this file corresponds
// to the files ConsumerInterface.m and ProducerInterface.m
//
// **********************************

// ProducerInterface.m                                        
// +++++++ start
#import "ProducerInterface.h"
// +++++++ end

@implementation ProducerInterface

  // all data are here considered in their external metrics; all the job
  // of tranforming the external metrics to the internal one (useful for
  // a neural netowrk) and then to the external one again is done
  // automatically using the various matrixes, which are contained in objects
  // that respond to the ...asExternal... methods, which apply the internal
  // and external min-max intervals contained in the minmax matrix

  // the following methods are strictly related to the meaning the problem
  // data to which we are applying our neural network have

  // so we have to modify them whenever we change the problem if we want
  // to display agent data or operate with them in a CT way

  // the following "get" methods link the external names (used by the model
  // builder as variables) to the inputs/outputs/targets of the neural
  // network, where they are identified by a position in the input, output,
  // target vectors

// +++++++ start
- (float)getRevenue0
         // Revenue0     is the first input of a Producer in the
         // 'ct-hayek' application
{
  int k;
  // in each get we access a different pattern, as in a loop,
  // restarting from the first at the end (we use here the remainder of
  // the integer quotient calculated below with the % or Mod operator)

  // the mechanism for counting by 0.5 is expalined in SpecificInterface.m
  // in the parent code bp-ct

  k = nRevenue0;
  nRevenue0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                           withShift: 0];
  // withShift: 0 has the meaning of no shift, because minmax (row) position
  // matches perfectly dataVerificationMatrix (col) position
}

- (float)getProductionStream0
         // ProductionStream0 is the second input of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nProductionStream0;
  nProductionStream0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                           withShift: 0];
}

- (float)getP0
         // P0           is the third  input of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nP0;
  nP0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 2 asExternalValueUsing: minmax
                                           withShift: 0];
}

- (float)getQ0
         // Q0           is the fourth input of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nQ0;
  nQ0+=0.5;
  k = k % patternNumberInVerificationSet;

  return [dataVerificationMatrix R: k C: 3 asExternalValueUsing: minmax
                                           withShift: 0];
}

- (float)getActualP_out
         // ActualP_out     is the first   output of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualP_out;
  nActualP_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
  // withShift: inputNodeNumber matches minmax (row)
  // position and outputVerificationMatrix (col) position
  // (we have to use it here in all "get" methods which are related
  // to outputs or targets)
}

- (float)getActualP_target
         // ActualP_target  is the first   target of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualP_target;
  nActualP_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 0 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
  // withShift: inputNodeNumber matches minmax (row)
  // position and targetVerificationMatrix (col) position
  // (we have to use it here in all "get" methods which are related
  // to outputs or targets)
}

- (float)getActualQ_out
         // ActualQ_out     is the second  output in the 'hayek' application
{
  int k;
  k = nActualQ_out;
  nActualQ_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getActualQ_target
         // ActualQ_target  is the second  target of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nActualQ_target;
  nActualQ_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getActualQ_target_devidedBy10
         // ActualQ_target  is the second  target (a variant) of a Producer
         // in the 'ct-hayek' application
{
  int k;
  k = nActualQ_target_devidedBy10;
  nActualQ_target_devidedBy10+=0.5;
  k = k % patternNumberInVerificationSet;

  return 0.1*[targetVerificationMatrix R: k C: 1 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getRevenue_out
         // Revenue_out     is the third   output of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nRevenue_out;
  nRevenue_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 2 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getRevenue_target
         // Revenue_target
         //                 is the third   target in the
         // 'ct-hayek' application
{
  int k;
  k = nRevenue_target;
  nRevenue_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 2 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getProductionStream_out
         // ProductionStream_out     is the fourth output of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nRevenue_out;
  nRevenue_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 3 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getProductionStream_target
         // ProductionStream_target
         //                 is the fourth  target of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nRevenue_target;
  nRevenue_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 3 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getP_out
         // P_out           is the fifth   output of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nP_out;
  nP_out+=0.5;
  k = k % patternNumberInVerificationSet;

  return [outputVerificationMatrix R: k C: 4 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getP_target
         // P_target        is the fifth   target of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nP_target;
  nP_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 4 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getQ_out
         // Q_out           is the sixth   output of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nQ_out;
  nQ_out+=0.5;
  k = k % patternNumberInVerificationSet;
  return [outputVerificationMatrix R: k C: 5 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

- (float)getQ_target
         // Q_target        is the sixth   target of a Producer in the
         // 'ct-hayek' application
{
  int k;
  k = nQ_target;
  nQ_target+=0.5;
  k = k % patternNumberInVerificationSet;

  return [targetVerificationMatrix R: k C: 5 asExternalValueUsing: minmax
                                              withShift: inputNodeNumber];
}

  // special set methods used in this application (only on the Producer side)
  // as tools to communicate values in CT building

- setActualP_target_via_CT: (float) v
{
  actualP_target=v;
  return self;
}

- setActualQ_target_via_CT: (float) v
{
  actualQ_target=v;
  return self;
}
// +++++++ end

- initialize 
{
  int i;
  int outputNodeNumber;
  outputNodeNumber=[myAgentDataWarehouse getOutputNodeNumber];

  // counter initialization (strictly related to our application)

// +++++++ start
  nRevenue0=0; nProductionStream0=0; nP0=0; nQ0=0;
  nActualP_out   =0; nActualQ_out   =0; nRevenue_out   =0;
  nP_out   =0; nQ_out   =0;
  nActualP_target=0; nActualQ_target=0; nActualQ_target_devidedBy10=0;
  nRevenue_target=0; nProductionStream_target=0;
  nP_target=0; nQ_target=0;
// +++++++ end

  // the counter mechanism works in the following way
  // the Observer gets the values via one of the methods reported above;
  // the counter is increased twice a cycle (with a step of 0.5, giving 1),
  // because the Observer display widget (which is also reporting data
  // in a file) makes two calls to the method

  // the integer remainder obtained dividing the counter
  // by the number of the patterns, lays always between 0 and
  // patternNumberInVerificationSet-1

  // in the CT case the number of calls can be odd, due to the interface
  // calls used to build targets: in this case, anyway,
  // patternNumberInVerificationSet is equal to -1 and the result of 
  // k % patternNumberInVerificationSet is always 0

  // the following lines are useful only in CT scheme if we look (via get...)
  // for initial values in outputVerificationMatrix (initial values are
  // stored in dataTrainingMatrix via DataWarehouse createEnd method)

  for (i=0;i<outputNodeNumber;i++)
  [outputVerificationMatrix R:0 C: i setFrom:
                            [dataTrainingMatrix R:0 C: i+inputNodeNumber]];

  return self;
}

- setCT_Inputs
{

  // preserving previuously generated data, in CT scheme
  // when abs(patternNumberInTrainingSet)>1 ;
  // if abs(patternNumberInTraingingSet)=1 'shift' returns without effects
  [dataTrainingMatrix shift];

  // inputs:
  // we have to provide inputs (the same) both to the
  // dataVerificationMatrix (used in the no-learning acting phase in CT)
  // and to the dataTrainingMatrix (used in learning phase)

  // the learning phase uses one or more patterns and may be repeated in
  // each step (see the HowToUseBp-Ct.txt in the bp-ct package)
  // we store the data always in dataTrainingMatrix last row; the shift
  // order done above assures that the line is free and previous data are
  // preserved

// +++++++ start
  // input values come from the same agent outputs in the previous
  // cycle or action day (the get... messages are sent to self, i.e. the agent)
  // in the first cycle or action day data come the initial values

  // Revenue0
  [dataVerificationMatrix R:0      C:0 setFrom: [self getRevenue_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:0 setFrom: [self getRevenue_out]
                                  asExternalValueUsing: minmax withShift: 0];

  // ProductionStream0
  [dataVerificationMatrix R:0      C:1 setFrom: [self getProductionStream_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:1 setFrom: [self getProductionStream_out]
                                  asExternalValueUsing: minmax withShift: 0];

  // P0
  [dataVerificationMatrix R:0      C:2 setFrom: [self getP_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:2 setFrom: [self getP_out]
                                  asExternalValueUsing: minmax withShift: 0];

  // Q0
  [dataVerificationMatrix R:0      C:3 setFrom: [self getQ_out]
                                  asExternalValueUsing: minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC:3 setFrom: [self getQ_out]
                                  asExternalValueUsing: minmax withShift: 0];
// +++++++ end

  return self;
}

- setCT_Targets
{
  // NB. A general rule: IF WE NEED TO USE OTHER AGENTS OUTPUTS TO
  // GENERATE TARGETS WE MUST TO MANDATORYLY REFER TO OUTPUTS IN VERIFICATION
  // SET; we observe automatically this general rule if we build the getXXX
  // methods in interface objects as it is done in the introductory packages
  // bp-ct and ct-hayek, i.e. always getting inputs, outputs and targets
  // from the verification matrixes and - obviously - if we access values
  // only by means of those getXXX methods (addressed to other agents'
  // interfaces)


  // CT values (*)   

// +++++++ start
  // ActualP
  // this value is established by the consumer we are bargaining with,
  // as actualP_target (via the set method defined above); we constrain the
  // received value to lay between the allowed min and max

  if(actualP_target < [minmax R: 4 C: 0])actualP_target=[minmax R:4 C: 0];
  if(actualP_target > [minmax R: 4 C: 1])actualP_target=[minmax R:4 C: 1];

  // having 4 inputs, rows from 0 to 3 of minmax matrix are assigned to
  // their min and manx values (external min and max, cols 0 and 1; internal
  // ones, cols 2 and 3)
  // row 4 is related to the first output/target (we could also note
  // 'inputNodeNumber+0' instead of '4')

  // in CT scheme ActualP_target is not arising from the cross target system,
  // being a value received by another agent (able to fix the price)


  // actualQ
  // this value is established by the consumer we are bargaining with,
  // as actualQ_target (via the set method defined above)
  if(actualQ_target < [minmax R: 5 C: 0])actualQ_target=[minmax R:5 C: 0];
  if(actualQ_target > [minmax R: 5 C: 1])actualQ_target=[minmax R:5 C: 1];

  // see above the notes about actualP


  // Revenue

  // this, on the side of the effects, is a CT-like target, based upon
  // actions; the learning process will produce
  // outputs closer and closer to the consequences of the actions
  myP=[self getP_out];
  myQ=[self getQ_out];
  revenue_target = myP * myQ;
  if(revenue_target < [minmax R: 6 C: 0])revenue_target=[minmax R:6 C: 0];
  if(revenue_target > [minmax R: 6 C: 1])revenue_target=[minmax R:6 C: 1];

  // always on the side of the effects we have here an external objective
  // (EO) as target that, in case, substitutes (see below) the orginal
  // CT target
  revenue0=[self getRevenue0];
  revenueEO_target = revenue0*1.02; // EO: to increase revenue
  if(revenueEO_target < [minmax R: 6 C: 0])revenueEO_target=[minmax R:6 C: 0];
  if(revenueEO_target > [minmax R: 6 C: 1])revenueEO_target=[minmax R:6 C: 1];


  // the ProductionStream (daily production) is simply set equal to the sold
  // quantity (which indirectly is the consequence of actions, so the CT
  // scheme is respected);
  // this effect has been introduced only to use an EO
  productionStream_target = actualQ_target;
  if(productionStream_target < [minmax R: 7 C: 0])
                                     productionStream_target=[minmax R:7 C: 0];
  if(productionStream_target > [minmax R: 7 C: 1])
                                     productionStream_target=[minmax R:7 C: 1];

  // the EO - if used, see below - is here to keep constant
  // the production
  actualProductionStream=20;
  productionStreamEO_target = actualProductionStream;
  if(productionStreamEO_target < [minmax R: 7 C: 0])
                               productionStreamEO_target=[minmax R:7 C: 0];
  if(productionStreamEO_target > [minmax R: 7 C: 1])
                               productionStreamEO_target=[minmax R:7 C: 1];


  // P

  // here we have an action, with multiple possible corrections from various
  // effects, strictly in CT scheme

  // NB, in all apps, pay attention to the fact that when we have multiple
  // possible corrections, we have to compare the correction absolute values
  // and not the values of the corresponding action incorporating each
  // possible correction

  // to reduce the difference between revenue_out and revenue_target
  // we can modify P or Q (here we divide by myQ, acting on P); to
  // assign a share of the diference to P and the remainder to Q
  // we can use a random separating value in the range 0-1
  // more easily, here we divide the difference by 2
  revenue_out=[self getRevenue_out];
  correction1 = ((revenue_out-revenue_target)/2.)/myQ;

  // here the correction is determined as a fixed value
  productionStream_out=[self getProductionStream_out];
  correction2=0;
  if(productionStream_out < productionStream_target) correction2=  0.15;
  if(productionStream_out > productionStream_target) correction2= -0.15;

  // we use the max (fabs correctionX); fabs is float abs
  correction = correction1;
  if(fabs(correction2) > fabs(correction))correction=correction2;

  p_target = myP + correction;
  if(p_target < [minmax R: 8 C: 0])p_target=[minmax R:8 C: 0];
  if(p_target > [minmax R: 8 C: 1])p_target=[minmax R:8 C: 1];


  // Q

  // ses above the comments about P

  correction1 = ((revenue_out-revenue_target)/2.)/myP;

  // in this version the following corrections are not used
  correction2=0;
//  if(productionStream_out < productionStream_target) correction2=  2;
//  if(productionStream_out > productionStream_target) correction2= -2;

  correction = correction1;
  if(fabs(correction2) > fabs(correction))correction=correction2;

  q_target = myQ + correction;
  if(q_target < [minmax R: 9 C: 0])q_target=[minmax R:9 C: 0];
  if(q_target > [minmax R: 9 C: 1])q_target=[minmax R:9 C: 1];
// +++++++ end


  // targets  

  // values determined above are reported in the data matrixes, to be
  // used in the verification (acting) and in the training (with or without
  // long term learning) steps

  // the if conditions are related to the use of (i) none at all, (ii) a part
  // or (iii) all E0s (EP are here absent; they work on actions, exactly
  // the same way EOs work on effects)

  // NB values copied in dataTrainingMatrix are mandatorily sent to the last
  // row, with 'R_lastAndC:' message (remember the [dataTrainingMatrix shift]
  // instruction above, that empties the last row shifting up all patterns)

  // cols positions in matrixes below come from the names-positions
  // definitions made in the get... methods in the opening of this file


// +++++++ start
  // ActualP
  [dataVerificationMatrix R: 0     C: 4
                   setFrom: actualP_target     asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 4
                   setFrom: actualP_target     asExternalValueUsing:
                                               minmax withShift: 0];

  // ActualQ
  [dataVerificationMatrix R: 0     C: 5
                   setFrom: actualQ_target     asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 5
                   setFrom: actualQ_target     asExternalValueUsing:
                                               minmax withShift: 0];

  // Revenue
  if(useEO_EP==1 || useEO_EP==3)
              {
  [dataVerificationMatrix R: 0     C: 6
                   setFrom: revenueEO_target     asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 6
                   setFrom: revenueEO_target     asExternalValueUsing:
                                               minmax withShift: 0];
              }
  else        {
  [dataVerificationMatrix R: 0     C: 6
                   setFrom: revenue_target     asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 6
                   setFrom: revenue_target     asExternalValueUsing:
                                               minmax withShift: 0];
              }
  // ProductionStream
  if(useEO_EP==2 || useEO_EP==3)
              {
  [dataVerificationMatrix R: 0     C: 7
                   setFrom: productionStreamEO_target asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 7
                   setFrom: productionStreamEO_target asExternalValueUsing:
                                               minmax withShift: 0];
              }
  else        {
  [dataVerificationMatrix R: 0     C: 7
                   setFrom: productionStream_target   asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 7
                   setFrom: productionStream_target   asExternalValueUsing:
                                               minmax withShift: 0];
              }

  // P
  [dataVerificationMatrix R: 0     C: 8
                   setFrom: p_target           asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 8
                   setFrom: p_target           asExternalValueUsing:
                                               minmax withShift: 0];

  // Q
  [dataVerificationMatrix R: 0     C: 9
                   setFrom: q_target           asExternalValueUsing:
                                               minmax withShift: 0];
  [dataTrainingMatrix     R_lastAndC: 9
                   setFrom: q_target           asExternalValueUsing:
                                               minmax withShift: 0];
// +++++++ end
 
  return self;
}

@end

// (*) first of all we define the CT targets; then, in a second step (after
// '// targets' comment) we report those values in the requested
// matrixes
