#import "Hashtable.h"
#import "AsciiMemLogger.h"

@implementation AsciiMemLogger

+ create: aZone fileName: (const char*) fname
{
	AsciiMemLogger *obj;
	FILE *fp;

	obj = [AsciiMemLogger createBegin: aZone];
	
	if (fname)
		fp = fopen (fname, "w");
	else fp = stdout;
	[obj setOutputStream: [OutputStream create: aZone setFileStream: fp]];

	return [obj createEnd];
}

+ createBegin: aZone
{
	AsciiMemLogger *obj;
	
	obj = [super createBegin: aZone];
	
	obj->myRecordDelim = "\n";
	obj->myDataDelim = " ";
	obj->myStream = nil;
	obj->isCumulative = 0;

	return obj;
}

- (void) setCumulative
{
	isCumulative = 1;  // should lead to subclass/subprotocol later
}

- (void)setFilename: (char*) fname
{
	FILE *fp;

	if (fname)
		fp = fopen (fname, "w");
	else fp = stdout;

	myStream = [OutputStream create: [self getZone] setFileStream: fp];
}

- (void)setOutputStream: aStream
{
	myStream = aStream;
}

- (void)setRecordDelim: (const char*) rstr dataDelim: (const char*) dstr
{
	myRecordDelim = rstr;
	myDataDelim = dstr;
}

- createEnd
{
	if (myStream == nil)
	{
		myStream = [OutputStream createBegin: [self getZone]];
		[myStream setFileStream: stdout];
		myStream = [myStream createEnd];
	}

	if (isCumulative)
		myObjects = [[Hashtable alloc] initKeyDesc:"*" valueDesc:"i"];
	
	return [super createEnd];
}

- (void)consumeRecordTime: (timeval_t) aTime alloc: (int) i
    className: (char*) cname address: (void*) addr size: (long) size;
{
	char buf[256];
	int n=1;

	if (isCumulative)
	{
		if ([myObjects isKey: cname])
		{
			if (i)
				n = (int)[myObjects valueForKey: cname] + 1;
			else
				n = (int)[myObjects valueForKey: cname] - 1;
			if (n>0)
				[myObjects insertKey: cname value: (id)n];
			else
				[myObjects removekey: cname];  // really? might be useful
		}
		else
			if (i) 
				[myObjects insertKey: cname value: (id)n=1];
			else
				n = 0; 
	}

	sprintf (buf, "%ld%s%c%s%s%s%p%s%ld%s%d%s",
		aTime,
		myDataDelim,
		i? '+':'-',
		myDataDelim,
		cname,
		myDataDelim,
		addr,
		myDataDelim,
		size,
		myDataDelim,
		n,
		myRecordDelim);

	[myStream catC: buf];
}

-(void) drop
{
	[myObjects free];
	[super drop];
}
