//Setter.m

#import "Setter.h"
#import <simtools.h>
#import "Voter.h"
#import "CountHeads.h"
#import "dimarray.h"
#import <math.h>
#import <random.h>
#import <collections.h>   //for Array

@implementation Setter

-setWorld: (id) w  {
   world = w;
   return self;
}

-createEnd {
      [super createEnd];
    worldXSize = [world getSizeX];
    worldYSize = [world getSizeY];
    winner=[PolicyPoint createBegin: [self getZone]];
    [winner setWorld: world];
    winner = [winner createEnd];  
 
   return self;
}

-(double) getInstability {
      return winPct;

   }

-(void) startRNG 
{
  

  aGenerator = [SWB1 create: [self getZone] setStateFromSeed: 23 ];
  aNormalDist= [NormalDistribution create: [self getZone] 
				    setGenerator:  aGenerator
				    setMean: 0 setVariance: 1];
  //Uncomment next 2 to get a "test" of the random number process
  {
    float aNormalValue=0;
     aNormalValue=[aNormalDist getDoubleSample];
     printf("Here is a Normal Value: %f \n",aNormalValue);
  }
 } 
   


-(double) getStability {
      return since;
   }   

-sayHi {
   printf("Hi, I'm a Setter object\n");

   return self;
   }
-setInitialDirection: (double) value {
   angle=value;
   newangle=value;
   return self;
   }

-setLongestStep: (int) value {
   longestStep= value;
   return self;
}
   
-setWidthOfSearch: (double) value {
   widthOfSearch=value;
   return self;
   }   

-setWinPct: (double) value {
  
    winPct= value;
    return self;
    }

-setVoterList: (id) list
{
  //This shows how to pass in a list that can be kept for records.  Any changes that occur
  //in the voterList in other classes will be automatically reflected and so any calls
  //in this class to voterList will always get the right thing.
  voterList=list;
  return self;
}

//This is written to allow a different list than voterList to be passed through,
//but I don't do anything with that ability, really.  But if I wanted to randomly
//sample to create sublists, I could put them through here.

-(id)evaluateC: (id)  current  P: (id)  proposal L: (id) myList
{
  int j;
  Voter * aVoter;
     
  id distribution, ind , counter;
  //diagnostics to double-check objects that are passed through
  //   printf("\n setter evaluate \n");
  //    printf("proposal\n");

  //    [proposal sayHi];

  //    printf("current\n");
  //    [current sayHi];
  //   printf("The voterList has %d",[voterList getCount]);
  //   printf("The voter list passed in has %d \n", [myList getCount]);

  distribution=[Array create: [self getZone] setCount: 2 ];
    
  for(j=0;j<[distribution getCount];j++) 
    {
    counter=[CountHeads create:[self getZone]];
    [distribution atOffset: j put: [counter zeroOut]];
    }


  ind=[voterList begin:[self getZone]];
  while((aVoter=[ind next]))
    [[distribution atOffset:[aVoter reportX: proposal Y: current ]]
      addOne];
  [ind drop];

  printf("RESULTS \n");
  for(j=0;j<[distribution getCount];j++)
    printf("Number of Voters who choose value %d: %d\n",j,[[distribution atOffset:
								    j] getCnt]);         

  numElections+=1; since+=1;
 
 
  if  ([[distribution atOffset: 0]getCnt]< [[distribution atOffset:1]
					     getCnt])
    
    {
      printf("And the winner was the new proposal, %f, %f \n",[proposal getPolX],[proposal getPolY]);
      since=0;
      [winner setEqualTo:proposal];
      [current setEqualTo:proposal];
      printf("before the angle was %f, \n",angle);
      newangle= angle ;
      printf("new angle is %f, \n",angle);
      [proposal setPolicyColor: 2];
       
      //       printf("inside evaluate, the winner is %f,%f \n",[current getPolX],[current getPolY]);
      numWinners+= 1;     
    }    
  else
    {
    printf("The winner was the status quo!");
    [proposal setPolicyColor:3];
    }
  winPct= (100.0 * numWinners) /  (1.0 * numElections) ;
  printf("the number of proposals that beat the sq is %d out of %d elections and the percentage is
    %f \n",numWinners,numElections,winPct); 
    
  return current;
    
}

-(id) giveLocation{       
       return winner;

 }

-(id) makeProp:  x to: p {

  //printf("inside makeprop, it used to be %f, %f", [x getPolX], [x getPolY]);
  //Explanation of angle.  The width is set in radians at run time.  If it is 2,
  //then the movement is in a circle, according to the Normal Dist which has the most
  // likely outcome as continue in same direction.  When the width is reduced, the
  // direction is scaled to still be normally distributed but the variance collapses.
  // Confusing enough?  When the Normal returns a value less than -2 or greater than 2,
  // it truncates to make the change in the angle the extreme value.   
    
    dimarray newpos;
    newpos[0]=0;
    newpos[1]=1;
//     printf("Inside makeprop, newangle entering is %f \n",newangle);

    diff=[aNormalDist getDoubleSample];
         if (diff <= -2)  deltaTheta = -0.5* widthOfSearch;
         if (diff >= 2) deltaTheta = 0.5 * widthOfSearch;
         if (diff > -2 && diff < 2) deltaTheta =  (diff / 4.0) * widthOfSearch; 

    angle= newangle + deltaTheta;


    printf("The setter, direction was  %f, is %f, deltaTheta %f,diff %f \n",newangle,angle,deltaTheta,diff);
     distance= [uniformDblRand getDoubleWithMin: 0 withMax: +longestStep];
  
     newpos[0]= [x getPolX] + distance*cos(angle*M_PI);
     newpos[1]= [x getPolY] + distance*sin(angle*M_PI); 
printf("dist: %f, cos(angle):%f, sin(angle): %f \n",distance,cos(angle*M_PI),sin(angle*M_PI));
printf("pi, %f , sin(pi), %f ",M_PI, sin(M_PI));
// [x setPolicyColor: 2];
     [p setPos: newpos];  
     // [p setPolicyColor: 3];
       
     printf("proposal: %f,%f, SQ: %f,%f, Angle: %f \n" , [p getPolX],[p getPolY],[x getPolX],[x getPolY],angle); 

    return self;
 }


@end
