/* 
  ParameterManager.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  16-OCT-1996

*/

#import <swarmobject.h>
#import <simtools.h>

@interface ParameterManager : SwarmObject {
  id probeDisplay;
  double catalystMobilityFactor;
  double productionProbability;
  double linkMobilityFactor;
  double disintegrationProbability;
  double chainInitiateProbability;
  double chainExtendProbability;
  double chainSpliceProbability;
  double absorptionProbability;
  double emissionProbability;
  double substrateMobilityFactor;
  double holeMobilityFactor;
  double bondDecayProbability;
  BOOL chainInhibitBondFlag;
  BOOL catInhibitBondFlag;
  BOOL mooreNeighborFlag;
  unsigned timerKludge;
}

-(void) setCatalystMobilityFactor: (double) mobilityFactor;
-(double) getCatalystMobilityFactor;
-(void) setProductionProbability: (double) probability;
-(double) getProductionProbability;

-(void) setLinkMobilityFactor: (double) mobilityFactor;
-(double) getLinkMobilityFactor;
-(void) setChainInhibitBondFlag: (BOOL) value;
-(BOOL) getChainInhibitBondFlag;
-(void) setCatInhibitBondFlag: (BOOL) value;
-(BOOL) getCatInhibitBondFlag;
-(void) setDisintegrationProbability: (double) probability;
-(double) getDisintegrationProbability;
-(void) setChainInitiateProbability: (double) probability;
-(double) getChainInitiateProbability;
-(void) setChainExtendProbability: (double) probability;
-(double) getChainExtendProbability;
-(void) setChainSpliceProbability: (double) probability;
-(double) getChainSpliceProbability;
-(void) setAbsorptionProbability: (double) probability;
-(double) getAbsorptionProbability;
-(void) setEmissionProbability: (double) probability;
-(double) getEmissionProbability;

-(void) setSubstrateMobilityFactor: (double) mobilityFactor;
-(double) getSubstrateMobilityFactor;

-(void) setHoleMobilityFactor: (double) mobilityFactor;
-(double) getHoleMobilityFactor;

-(void) setBondDecayProbability: (double) probability;
-(double) getBondDecayProbability;

-(void) setTimerKludge: (unsigned) kludge;
-(unsigned) getTimerKludge;

-(void) setVNneighbor;
-(void) setMooreNeighbor;
-(BOOL) getMooreNeighborFlag;

-(void) apply;
-(void) step;

-saveToFileNamed: (char *) filename;
-loadFromFileNamed: (char *) filename;

@end
