/*
  Bernoulli.m

   Barry McMullin <mcmullin@eeng.dcu.ie>
   09-OCT-1996
*/

#import "Bernoulli.h"


@implementation Bernoulli

+(id) create: (id) aZone setGenerator: (id) generator {
  Bernoulli * finalSelf;

  finalSelf = [super create: aZone];
  finalSelf->uniformDouble = 
    [UniformDouble createBegin: aZone];
  [finalSelf->uniformDouble setGenerator: generator];
  [finalSelf->uniformDouble setDoubleMin: 0.0 setMax: 1.0];
  finalSelf->uniformDouble = 
    [finalSelf->uniformDouble createEnd];

  return finalSelf;
}

-(BOOL) getTossWithProb: (double) p {
  return([uniformDouble getDoubleSample] < p);
}

-(void) drop {
  [uniformDouble drop];
  [super drop];
}

@end
