/* 
  Coord2d.h

  A Coord2d is a Coord object designed for use with the
  Lattice2d class of Lattice.  It may be thought of as
  encapsulating an (x,y) rectangular co-ordinate
  pair. Any methods involving movement of the
  co-ordinate position in the Lattice2d implement
  toroidal boundary conditions.  The underlying Lattice2d
  can be (dynamically) configured as either a square or
  triangular tiling, and either Von Neumann, Moore, or
  FHP default neighborhood.  The Coord2d object can
  correctly process all Neighbor codes for any of these
  neighborhoods (with their implied tiling).  

  The Coord2d object can also generate corresponding 
  "raster" coordinates; in the case of a Square tiling
  these are simply scaled versions of the underlying
  (x,y) values; in the case of a Triangular tiling, the
  raster co-ordinates of alternate columns of the
  underlying (x,y) system are shifted by half a raster
  "unit".  This gives a fair approximation of
  rasterizing a regular triangular tiling, though the
  aspect ratio will still be somewhat distorted. To
  make use of this rasterizing mechanism, The absolute
  size of a raster "unit", in pixels, must be correctly
  specified in the Lattice object, as the
  "rasterScaleFactor".

  Barry McMullin <mcmullin@eeng.dcu.ie>
  FEB-1997

*/

#import <swarmobject.h>
#import <space.h>

#import "Coord.h"

@class Lattice2d;

@interface Coord2d : SwarmObject <Coord> {
  Lattice2d *lattice;
  int x;
  int y; 
}

-(void) setX: (int) inX;
-(int) getX;
-(void) setY: (int) inY;
-(int) getY;


// Raster co-ordinates reflect the raster scaling
// factor *and* tiling of the underlying lattice.
-(void) setRasterX: (int) inRasterX;
-(int) getRasterX;
-(void) setRasterY: (int) inRasterY;
-(int) getRasterY;

@end
