/* 
  NeighborCode.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  JAN-1997


  This header just defines the enumerated type NeighborCode
  This type provides symbolic (and possibly even meaningful)
  names for neighbor sites on a 2d square or triangular 
  lattice. That's all.

 "Center" refers to the reference site itself; it's somewhat
  redundant to include it as a "neighbor", but it may
  simplify some iterative precedures. "SqrFarNorth" is *two*
  cells North, etc.

*/

typedef enum { 
   Center,
   SqrNorth, SqrEast, SqrSouth, SqrWest, 
   SqrNorthEast, SqrSouthEast, SqrSouthWest, SqrNorthWest,
   SqrFarNorth, SqrFarEast, SqrFarSouth, SqrFarWest,
   TriNorth, TriNorthEast, TriSouthEast,
   TriSouth, TriSouthWest, TriNorthWest
  } NeighborCode;
   
