/* 
  VNneighborhood.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  JAN-1997

  A vnneighborhood can cycle through certain values of the 
  enumerated type SqrNeighborCode (see SqrNeighborCode.h) 
  corresponding to the neighbors in the Von Neumann 
  neighborhood - i.e. SqrNorth, SqrEast, SqrSouth, SqrWest.

*/

#import <swarmobject.h>

#import "Neighborhood.h"

@interface VNneighborhood: SwarmObject <Neighborhood>
{
  id uniformUnsigned;
}


/* The -next and -previous methods each rotate the
  given neighbor by 90 degrees.  -next cycles in the
  order SqrNorth-SqrEast-SqrSouth-SqrWest; 
  -previous cycles in the reverse order.
*/


@end
