/* 
  MooreNeighborhood.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  JAN-1997

  A mooreneighborhood can cycle through the values of the
  enumerated type NeighborCode (see NeighborCode.h)
  corresponding to the neighbors in the Moore
  neighborhood - i.e.  SqrNorth, SqrNorthEast, SqrEast, 
  SqrSouthEast, SqrSouth, SqrSouthWest, SqrWest and 
  SqrNorthWest.

*/

#import <objectbase/SwarmObject.h>

#import "Neighborhood.h"

@interface MooreNeighborhood: SwarmObject <Neighborhood>
{
  id uniformUnsigned;
}

/* The -next and -previous methods each rotate the
  given neighbor by 45 degrees.  -next cycles in the
  order SqrNorth-SqrNorthEast-SqrEast-SqrSouthEast-
  SqrSouth-SqrSouthWest-SqrWest-SqrNorthWest; 
  -previous cycles in the reverse order.
*/


@end
