// ThreeD.h

// Copyright (C) 1996 The Santa Fe Institute.
// No warranty implied, see LICENSE for terms.

#import <objectbase/SwarmObject.h>	 // we inherit swarm objects

// from the assumed 2D coordinate system in a swarm grid, we used the virtual 3D system:
// (top view) 
//  X .-----------------> Y
//    |
//    | 
//    |
//  . |
//    |
//    Z
// 

@interface Point3D: SwarmObject
{
  int x; // heigth
  int y; // width
  int z; // depth
  int label; // name
}

- setParam: (int)_x: (int)_: (int)_z: (int)_label;

// send methods
- (int)sendx;
- (int)sendy;
- (int)sendz;
- (int)sendlabel; 

@end
