

//Charge.m       potential     by Artan Simeqi

#import "Charge.h"
#include <math.h>

@implementation Charge

-setWorld: (id) w {
world = w;
return self;
}

-createEnd {
[super createEnd];
worldXSize= [world getSizeX];
worldYSize= [world getSizeY];
return self;
}

-setX: (int) x Y: (int) y {
xPos = x;
yPos = y;
return self;
}


-setCharge: (double) c Sign: (int) s {
charge=c;
sign=s;
return self;
}

- (double) getCharge {
return charge;
}

-drawSelfOn: (Raster *) r {
[r drawPointX: xPos Y: yPos Color: (sign+1)]; //Red color is negative charge
					      //Yellow color is positive
					      //White color is neutral
return self;
}


- (double) getContributionAtX: (int) x Y: (int) y {

// I like this function too much. I think here we can understand 
// the power of Object Oriented programming.
// Any point of type Ppoint call this method for each Charge.
// So each Ppoint ask all the charges about the contribution
// they give in the potential in the coordinates where the Ppoint is.
 
double pot, dist;
if (charge==0)
return 0;

dist = sqrt((xPos-x)*(xPos-x)+(yPos-y)*(yPos-y));
if (dist<5) 
dist=5;

pot = charge*sign/dist;

return pot;
}
@end


