// ObserverSwarm.h				simpleObserverBug2

#import "ModelSwarm.h"

#import <swarmobject.h>
#import <space.h>
#import <activity.h>
#import <tkobjc.h>
#import <collections.h>
#import <simtools.h>
#import <analysis.h>

@interface ObserverSwarm : GUISwarm {
  int displayFrequency;                           // one parameter: update freq

  id displayActions;                              // schedule data structs
  id displaySchedule;

  ModelSwarm * modelSwarm;          		  // the Swarm we're observing

  // Lots of display objects. First, widgets

  XColormap * colorMap;                           // allocate colours
  ZoomRaster * worldRaster;                       // 2d display widget

 // Now, higher order display and data objects

  Object2dDisplay * pointDisplay;                   // display the points
  Object2dDisplay * chargeDisplay;                   // display the charges
}

// Methods overriden to make the Swarm.

+createBegin: (id) aZone;
-createEnd;

-buildObjects;
-buildActions;
-activateIn: (id) swarmContext;

@end








