import swarm.Globals;
import swarm.activity.ScheduleImpl;
import swarm.activity.Schedule;
import swarm.activity.Activity;
import swarm.objectbase.Swarm;
import swarm.objectbase.SwarmImpl;
import swarm.defobj.Zone;
import swarm.Selector;

public class Repeaters extends SwarmImpl {
  public BugA bugA;
  public BugB bugB;
  public Schedule stopSchedule;

  public Repeaters (Zone aZone) {
    super (aZone);
  }

  public Object buildObjects () {
    bugA = new BugA (getZone ());
    bugB = new BugB (getZone ());

    bugA.buildObjects ();
    bugB.buildObjects ();
    return this;
  }

  public Object stop () {
    System.out.println ("Stopping @ "
                        + getActivity ().getSwarmActivity ().getCurrentTime ());
    getActivity ().terminate ();
    return this;
  }
  
  public Object buildActions () {
    super.buildActions ();

    bugA.buildActions ();
    bugB.buildActions ();
    stopSchedule = new ScheduleImpl (getZone (), true);

    try {
      Selector sel = new Selector (getClass (), "stop", false);

      stopSchedule.at$createActionTo$message (25, this, sel);
    } catch (Exception e) {
      e.printStackTrace (System.err);
    }
    return this;
  }

  public Activity activateIn (Swarm swarmContext) {
    super.activateIn (swarmContext);

    bugA.activateIn (this);
    bugB.activateIn (this);
    stopSchedule.activateIn (this);
    return getActivity ();
  }
  
  public static void main (String[] args) {
    Globals.env.initSwarm ("Repeaters", "0.0", "bug-swarm@swarm.org", args);
    
    Repeaters repeaters = new Repeaters (Globals.env.globalZone);
    
    repeaters.buildObjects ();
    repeaters.buildActions ();
    repeaters.activateIn (null).run ();
  }
}
