// Neural Network Library. Copyright (C) 1996 Juan J. Merelo.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.


#ifndef __BASESINGLELAYER_H
#define __BASESINGLELAYER_H

#include "neuron.h"		// Protocol for neurons

// Abstract base class for SingleLayer neural networks. Shouldn't
// be used standalone, must inherit from int.

@interface BaseSingleLayer: SwarmObject <NN, Unsupervised, SingleLayer> { 
    float alpha;
    unsigned inpSize, numNeurons;
    float *inpLy, *Wgts, *opLy;	// Input, Weights and output layer
}

@end

#endif
