// Neural Network Library. Copyright (C) 1996 Juan J. Merelo.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#ifndef _CRNN_H
#define _CRNN_H

#include "neuron.h"

//Implementation of Beer's continuous recurrent neural networks,
//except that all time constants are the same.

@interface CRNN:SwarmObject <NN, Recurrent> {
    unsigned numNeurons;
    float *y, *yPlus,		// neuron activation, t and t+1
	*inputs, *bias,		// Inputs and biases
	*weights, *taus;	// Weights and time constants
}
@end
#endif
