// Neural Network Library. Copyright (C) 1996 Juan J. Merelo.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// -*- mode: objc; c-indent-level: 4; comment-column: 35 -*-

// This version 2 attempts compatibility with Swarm

// Version 3 starts to use graphics

// Version 4 uses forms

// Version kkheb2ly es igual, pero para una hebbiana de dos capas...

// Now compiles cleanly for swarm version 0807

// kkcl.m es una adaptacion, para probar CompLearning

#import <defobj.h>

#import <tkobjc.h>		   // For all the definitions and stuff
#import <simtools.h>		   // For simulation parameters

#import "CRNN.h"

unsigned numNeurons = 2;

SimParameters * simParameters;

void doForm();

char *Colors[] = {
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
};

void main( int argc, char** argv) {

    id aZone;			// Allocation zone
    id neura;			// Neural network
    unsigned i,j, error;

    BLTGraph  *wgtGraph, *attrGraph;
    GraphElement  *wgtData, *ptData, *attrData;

    // Initialize swarm
    initSwarm( argc, argv);

    doForm();

    aZone = [Zone create: NULL];

    neura = [CRNN createBegin: aZone];
    [neura setNumberNeurons: numNeurons ]; 
    [neura setRandomWeights];
    if ( ! (neura = [neura createEnd])  )
	[InvalidCombination raiseEvent: "NN not created"]; // Neural network created

    // Create Graph
    wgtGraph = [ BLTGraph create: aZone];
    [wgtGraph setWidth: 600 Height: 370];
    [wgtGraph setRangesXMin: -1.5 Max:1.5 YMin:-1.5 Max :1.5];
    [wgtGraph title: "Activation wandering" ];
    [wgtGraph axisLabelsX: "neuron 0" Y: "neuron 1"];
    
    ptData = [wgtGraph createElement];
    [ptData setLabel: "Last Value" ];
    [ptData setColor: "Blue"];
    [ptData setSymbol: "diamond"];

    wgtData = [wgtGraph createElement];
    [wgtData setLabel: "Activation" ];
    [wgtData setColor: "Red"];
    [wgtGraph pack];

    attrGraph = [ BLTGraph createParent: [wgtGraph getParent]];
    [attrGraph setWidth: 600 Height: 370];
//    [attrGraph setRangesXMin: -1.5 Max:1.5 YMin:-1.5 Max :1.5];
    [attrGraph title: "Attractors" ];
    [attrGraph axisLabelsX: "neuron 0" Y: "neuron 1"];

    attrData = [attrGraph createElement];
    [attrData setLabel: "Attractors" ];
    [attrData setColor: "Green"];
    [attrData setSymbol: "circle"];
    [attrGraph pack];

    i = 0; error = 0;
    while ( [simControl getAllDone] == 0 ) {
	float *inp, *oldOut, *out;	// Generic input vector

	inp = (float*) calloc( numNeurons, sizeof(float));
	oldOut = (float*) calloc( numNeurons, sizeof(float));
	out = (float*) calloc( numNeurons, sizeof(float));

	while( ! simControl->running ) {
	    Tk_DoOneEvent(0);
	}

	while( Tk_DoOneEvent(TK_ALL_EVENTS|TK_DONT_WAIT))
	    ;

	for ( j = 0 ; j < numNeurons; j ++ ) {
	    inp[j] = [uniformRandom rFloat] * 2 -1 ;
	}

	[neura clamp: inp];
	[neura getActivation: out];
	for ( j = 0 ; j < numNeurons; j ++ ) {
	    inp[j] = 0.0;
	}
	[neura clamp: inp];
	while ( (oldOut[0]!= out[0]) && (oldOut[1] != out[1] ) ) {
	    [ptData resetData];
	    for ( j = 0 ; j < numNeurons; j ++ ) {
		oldOut[j] = out[j];
	    }
	    [ptData addX: out[0] Y: out[1] ];
	    [wgtData addX: out[0] Y: out[1] ];
	    [neura getActivation: out];
	}

//	[wgtGraph destroyElement: wgtData];  
	wgtData = [wgtGraph createElement];
	[wgtData setLabel: "" ];
	[wgtData setColor: "Red"];

	// Plot attractors
	[attrData addX: out[0] Y: out[1] ];

#ifdef STEP
	if ( simControl->step  )
	    simControl->running = 0;
#endif
	i++;
	free(inp);
	free(out);
	free(oldOut);
    }
}


// this is the current mechanism for setting simulation parameters.
// it will be changed when experiment objects are written.
void
doForm() {
#define NUMPARAMETERS 1
  Parameter p[NUMPARAMETERS] = {
    {"Number of neurons", &numNeurons, TCL_LINK_INT},
  };
  
  simParameters = [SimParameters createBegin: globalZone];
  [simParameters setParameterList: p Num: NUMPARAMETERS];
  if ( !( simParameters = [simParameters createEnd] ) ){
      [InvalidCombination raiseEvent: "La jodiste" ];
  }
  [simParameters readValues: simControl];
}



