// Neural Network Library. Copyright (C) 1996 Juan J. Merelo.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.


#ifndef __HEBB2LAYER_H
#define __HEBB2LAYER_H

#include <objc/Object.h>

#import <swarmobject/SwarmObject.h>

#import "neuron.h"		// Protocol for neurons

@interface Hebb2Layer: SwarmObject <NN, Unsupervised, MultiLayer> {
    float alpha, beta;		// Training constants
    unsigned inpSize, hidSize, opSize;
    float *inpLy, *Wgts1, *hidLy, *Wgts2, *opLy;	
				// Layer and weights
}

-normalize;			// Normalize Weights
@end

#endif
