// Neural Network Library. Copyright (C) 1996 Juan J. Merelo.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// -*- mode: objc; c-indent-level: 4; comment-column: 35 -*-

// This version 2 attempts compatibility with Swarm

// Version 3 starts to use graphics

// Version 4 uses forms

// kksom es muy parecido, pero usa graficos diferentes:
// La version 2 usa la nueva version de BLTGRAPH...
// Last version uses SOMplus, instead of the plain vanilla SOM

#import <defobj.h>
#import <tkobjc.h>
#import <simtools.h>	// For simulation parameters

#include "SOMplus.h"

#include <sys/types.h>

#define INPUTSIZE 2

unsigned numNeurons = 10;
double alpha = 0.2;
double alphaMult = 0.995;
unsigned initialNHood = 4;
unsigned selfOrg = 1000;
unsigned totSteps = 10000;
int dashes;

void doForm();

char *Colors[] = {
  "red", "orange", "yellow", "green", "blue", "purple", "grey50", "black",
};

void
main( int argc, char** argv) {

    id aZone;			// Allocation zone
    SOMplus* neura;			// Neural network
    unsigned i,j;
    float inp[INPUTSIZE];	// Generic input vector
    BLTGraph *wgtGraph;
    GraphElement *wgtData;
    char Labels[10];

    // Initialize swarm
    initSwarm( argc, argv);

    doForm();

    aZone = [Zone create: NULL];

    neura = [SOMplus createBegin: aZone];
    [neura setLayerSize: INPUTSIZE: numNeurons ];	// 3rd one does not matter
    [neura setRandomWeights];
    [neura setAlpha: (float) alpha Mult: (float) alphaMult];
    [neura setInitialNHood: initialNHood];
    [neura setSelfOrg: selfOrg];

    if ( !( neura = [neura createEnd]) )
	[InvalidCombination raiseEvent: "NN not created"]; // Neural network created

    // Create Graph
    wgtGraph = [BLTGraph create: aZone];
    [wgtGraph title: "Weight Wandering" ];
    [wgtGraph axisLabelsX: "WeightX" Y: "WeightY"];
    [wgtGraph packWith: "-fill both"];
    sprintf( Labels, "Weights");
    wgtData = [wgtGraph createElement];
    [wgtData setLabel: Labels ];
    [wgtData setColor: Colors[1]];
    [wgtData setSymbol: "circle" ];
    [wgtData setDashes: dashes ];

    i = 0; 
    while ( ( [simControl getAllDone] == 0 ) && (i < totSteps) ) {

	while( !simControl->running )
	    Tk_DoOneEvent(0);
	while( Tk_DoOneEvent(TK_ALL_EVENTS|TK_DONT_WAIT))
	    ;

	for ( j = 0 ; j < INPUTSIZE; j ++ ) {
	    inp[j] = [uniformRandom rFloat] * 2 -1 ;
	}

	// SOM network feeding and training
	[neura feedForward: inp];
	[neura train: 0 ];

	if ( i ) {		   // After the first iteration
	    [wgtData resetData];
	}

	for ( j = 0; j < numNeurons; j ++ ) {
	    float w1, w2;
	    w1 = [neura getWeights: j: 0 ];
	    w2 =  [neura getWeights: j: 1 ]; 
	    [wgtData addX: w1 Y:  w2];
	}

	i++;
    }

}


// this is the current mechanism for setting simulation parameters.
// it will be changed when experiment objects are written.
void
doForm() {
#define NUMPARAMETERS 7
  SimParameters * simParameters;
  Parameter p[NUMPARAMETERS] = {
      {"Number of output neurons", &numNeurons, TCL_LINK_INT},
      {"Learning parameter initial value", &alpha, TCL_LINK_DOUBLE},
      {"Learning parameter multiplier", &alphaMult, TCL_LINK_DOUBLE},
      {"initial neighborhood", &initialNHood, TCL_LINK_INT},
      {"Total steps", &totSteps, TCL_LINK_INT},
      {"Steps self-organizing phase", &selfOrg, TCL_LINK_INT},
      {"Dashed lines", &dashes, TCL_LINK_BOOLEAN},
  };
  
  simParameters = [SimParameters  createBegin: globalZone];
  [simParameters setParameterList: p Num: NUMPARAMETERS];
  if ( !( simParameters = [simParameters createEnd] ) ){
      [InvalidCombination raiseEvent: "La jodiste" ];
  }
  [simParameters readValues: simControl];
}



