// Neural Network Library. Copyright (C) 1996 Juan J. Merelo.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#ifndef __NEURON_P
#define __NEURON_P

//Standard includes
#include <stdio.h>
#include <malloc.h>
#include <math.h>

// Several things used throughout the library
#import <defobj.h>	// For UniformRandom
#import <simtools/global.h>
#import <swarmobject/SwarmObject.h> // for SwarmObject
#import <tkobjc/ZoomRaster.h>

#define BYTESWGT 2

@protocol NN 
// I/O related functions
-(unsigned) getInpSize;		// Number of input neurons
-(BOOL) getLayers;		// True if multilayer <only>

// Weight-related functions
-setRandomWeights;		// Randomize weights, result [-1,1]
-setFromString: (unsigned char *) _str;	// 2 bytes for each weight

// Destructor
-free;				// Dealloc everything
@end

@protocol FeedForward
// Input-related functions
-(unsigned ) feedForward: (float *) inpVec;
@end

@protocol Recurrent
// size and so:
-setNumberNeurons: (unsigned) _n;

// Input/Output related functions
-clamp: (float *) inpVec;
-getActivation: (float * ) _act;
@end

@protocol MultiLayer <FeedForward>

- setLayerSize: (unsigned) inpLyUnits 
	      : (unsigned) opLyUnits
	      : (unsigned) hdLyUnits; 

- (float) getWeights: (unsigned) Layer
		    : (unsigned) i
		    : (unsigned) j;// i index always runs over the bottom, or output layer
				
- setWeightsTo: (float * ) wgtsInputLayer: (float* )wgtsOutputLayer;
- setTrainingConstant: (float) _alpha : (float) _beta;

// Info functions
-(unsigned) getHiddenSize;

@end

@protocol SingleLayer <FeedForward>
- setLayerSize: (unsigned) inpLyUnits: (unsigned) opLyUnits;
- (float)   getWeights: (unsigned) i: (unsigned) j;
				// i index always runs over the lowest, or bottom layer
- setWeightsTo: (float * ) wgts;
- setTrainingConstant: (float) _alpha;
@end

@protocol Unsupervised		// Includes reinforced
- train: (float) delta;		// Reinforcement signal
@end

@protocol Supervised
- train: (float) delta: (float*) desiredOutputVec;
@end


// Non-object functions
float sigmoid( float _val);
#endif
