// ObserverSwarm.m

#import <random.h>
#import "ObserverSwarm.h"

@implementation ObserverSwarm

+ createBegin: aZone
{
  ObserverSwarm *obj;
  id <ProbeMap> probeMap;

  obj = [super createBegin: aZone];
  obj->worldSize=10;
    
  // Also, build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  [probeMap addProbe: [[probeLibrary getProbeForMessage: "moveToLeft:"
                                    inClass: [self class]]
                              setHideResult: 1]];
  [probeMap addProbe: [[probeLibrary getProbeForMessage: "moveToRight:"
                                    inClass: [self class]]
                              setHideResult: 1]];
  
  
  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

- createEnd
{
 
  return [super createEnd];
}

- buildObjects
{
  int x,y;
  int i=0;
  id aBug;
  char bugColors[64][20] ={"Green", "Blue","cyan3",     
                          "IndianRed1","SeaGreen","chartreuse",
                          "MediumOrchid4","DarkGoldenrod3","aquamarine3",
                          "yellow","PaleGreen","OrangeRed",
                          "MediumAquamarine","DodgerBlue","salmon1",
                          "DarkTurquoise","ForestGreen","DarkKhaki",
                          "LightSalmon2","Gold","PaleGreen3",
                          "LightPink", "IndianRed2", "LightBlue", 
                          "Purple", "DarkGreen", "SlateBlue4", 
                          "Black","aquamarine1","orange1",
                          "SandyBrown","Green","DeepPink",
                          "DarkOrchid","PeachPuff3","MediumPurple",
                          "bisque3","MediumOrchid","SkyBlue2",
                          "SeaGreen3","PaleTurquoise3","CadetBlue3",
                          "cyan3","DarkSlateGray3","DarkSeaGreen3",
                          "LightSteelBlue3","SaddleBrown","SpringGreen3",
                          "goldenrod3","salmon3","RosyBrown3",
                          "firebrick3","SlateBlue2","OrangeRed3",
                          "HotPink3","maroon3","VioletRed3",
                          "magenta3","cyan","green","DarkGoldenrod",
                          "GreenYellow","sienna","plum"};
 
  [super buildObjects];
  CREATE_PROBE_DISPLAY (self);
  [controlPanel setStateStopped];


  // Create a colormap that associates integer numbers
  // with named colors from the array allocated above
  colormap = [Colormap create: [self getZone]];
  for(i=0;i<64;i++)
    [colormap setColor: i ToName: bugColors[i]];    

  // Create two lists, one for agents in each "world" 
  leftBugList=[List create: self];
  rightBugList=[List create: self];
  
  // Next, create two 2d windows for display
  leftRaster=[ZoomRaster create: self];
  [leftRaster setColormap: colormap];
  [leftRaster setWidth: worldSize
                 Height: worldSize];
  [leftRaster setZoomFactor: 30];
  [leftRaster setWindowTitle: "LeftWorld"];
  [leftRaster pack];                 
  
  rightRaster=[ZoomRaster create: self];
  [rightRaster setColormap: colormap];
  [rightRaster setWidth: worldSize
                 Height: worldSize];
  [rightRaster setZoomFactor: 30];
  [rightRaster setWindowTitle: "RightWorld"];
  [rightRaster pack];   

  // We need 2d lattice objects to hold agent positions
  leftWorld = [Grid2d createBegin: self];
  [leftWorld setSizeX: worldSize Y: worldSize];
  leftWorld = [leftWorld createEnd];
  [leftWorld fillWithObject: nil];

  rightWorld = [Grid2d createBegin: self];
  [rightWorld setSizeX: worldSize Y: worldSize];
  rightWorld = [leftWorld createEnd];
  [rightWorld fillWithObject: nil];


  // And also create  Object2dDisplays. These objects draw agents
  // on the worldRaster widget for us and catch mouse-button clicks

  leftBugDisplay = [Object2dDisplay createBegin: self];
  [leftBugDisplay setDisplayWidget: leftRaster];
  [leftBugDisplay setDiscrete2dToDisplay: leftWorld];
  [leftBugDisplay setObjectCollection: leftBugList];
  [leftBugDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
  leftBugDisplay = [leftBugDisplay createEnd];

  rightBugDisplay = [Object2dDisplay createBegin: self];
  [rightBugDisplay setDisplayWidget: rightRaster];
  [rightBugDisplay setDiscrete2dToDisplay: rightWorld];
  [rightBugDisplay setObjectCollection: rightBugList];
  [rightBugDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
  rightBugDisplay = [rightBugDisplay createEnd];
  
  // This allows the user to right-click on the display to probe the bugs.

  [leftRaster setButton: ButtonRight
               Client: leftBugDisplay
               Message: M(makeProbeAtX:Y:)];
  [rightRaster setButton: ButtonRight
               Client: rightBugDisplay
               Message: M(makeProbeAtX:Y:)];


  SET_WINDOW_GEOMETRY_RECORD_NAME(leftRaster);
  SET_WINDOW_GEOMETRY_RECORD_NAME(rightRaster);

  // Now create the agents (called bugs here)
  // We only want 10% of the locations to be
  // filled and randomly send bugs with 50% prob
  // to each "world", the left or right raster
  for (x = 0; x < worldSize; x++) 
    for (y = 0; y < worldSize; y++) 
      if ([uniformDblRand getDoubleWithMin: 0.0 withMax: 1.0] < 0.10) {
	 i++;
         aBug = [Bug createBegin: self];
	 [aBug setX: x Y: y];
         aBug = [aBug createEnd];
       
	 [aBug setBugColor: i];

	 if([uniformIntRand getIntegerWithMin: 0 withMax: 1] < 1) {
	   [leftBugList addLast: aBug];
	   [aBug setWorld: leftWorld andList: leftBugList];
	 } else {
	   [rightBugList addLast: aBug];
	   [aBug setWorld: rightWorld andList: rightBugList];
	 }
      }
  
   return self;
}

- buildActions
{

// Create the actions necessary for the simulation. 

  [super buildActions];

  // This arranges the order of the updates on each object
  displayActions = [ActionGroup create: self];
  // We need to erase the raster after each time step, otherwise
  // the agents will leave a trail on the raster display
  [displayActions createActionTo: leftRaster message: M(erase)];
  [displayActions createActionTo: rightRaster message: M(erase)];

  // Then we want to ask each bug to move, i.e. exacute the step command
  [displayActions createActionForEach: leftBugList message: M(step)];
  [displayActions createActionForEach: rightBugList message: M(step)];

  // Now we ask the Object2dDisplays to work their magic, 
  // ask the bugs to draw themselves on the zoom raster. 
  [displayActions createActionTo: leftBugDisplay message: M(display)];
  [displayActions createActionTo: rightBugDisplay message: M(display)];

  // Finally the methods that actually refresh the raster image
  [displayActions createActionTo: leftRaster message: M(drawSelf)];
  [displayActions createActionTo: rightRaster message: M(drawSelf)];

  // And then we need to schedule an update of the whole widget set
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  
  // This concludes the ordering of actions,
  // now need to put this on a repeating schedule
  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: 1]; 
  displaySchedule = [displaySchedule createEnd];  
  [displaySchedule at: 0 createAction: displayActions];
   
  return self;
}

- activateIn: swarmContext
{
// activateIn: - activate the schedules so they're ready to run.

  [super activateIn: swarmContext];

  // Now activate our schedule in ourselves.
  [displaySchedule activateIn: self];

  // Activate returns the swarm activity - the thing that's ready to run.
  return [self getSwarmActivity];
}

-moveToLeft: b {
  // This method checks if bug is actually on the
  // right hand world and then moves the bug
  // by executing a method in the bug itself
  // If the bug is not in the right hand world
  // nothing happens...
  if([rightBugList contains: b]) 
    [b setWorld: leftWorld andList: leftBugList];
  
  return self;
}

-moveToRight: b {
  // This method checks if bug is actually on the
  // left hand world and then moves the bug
  // by executing a method in the bug itself
  // If the bug is not in the right hand world
  // nothing happens...
  if([leftBugList contains: b]) 
    [b setWorld: rightWorld andList: rightBugList];
  
  return self;
}
@end








