// ObserverSwarm.m

#import "ObserverSwarm.h"
#import "RankedList.h"
#import <simtoolsgui.h>
#import <random.h>
#import <analysis.h>

@implementation ObserverSwarm

+ createBegin: aZone
{
  ObserverSwarm *obj;

  obj = [super createBegin: aZone];
  obj->worldSize=10;

  return obj;
}

- createEnd
{
 
  return [super createEnd];
}

- buildObjects
{
  int x,y;
  int i=0;
  id aBug;
  char bugColors[64][20] ={"Green", "Blue","cyan3",     
                          "IndianRed1","SeaGreen","chartreuse",
                          "MediumOrchid4","DarkGoldenrod3","aquamarine3",
                          "yellow","PaleGreen","OrangeRed",
                          "MediumAquamarine","DodgerBlue","salmon1",
                          "DarkTurquoise","ForestGreen","DarkKhaki",
                          "LightSalmon2","Gold","PaleGreen3",
                          "LightPink", "IndianRed2", "LightBlue", 
                          "Purple", "DarkGreen", "SlateBlue4", 
                          "Black","aquamarine1","orange1",
                          "SandyBrown","Green","DeepPink",
                          "DarkOrchid","PeachPuff3","MediumPurple",
                          "bisque3","MediumOrchid","SkyBlue2",
                          "SeaGreen3","PaleTurquoise3","CadetBlue3",
                          "cyan3","DarkSlateGray3","DarkSeaGreen3",
                          "LightSteelBlue3","SaddleBrown","SpringGreen3",
                          "goldenrod3","salmon3","RosyBrown3",
                          "firebrick3","SlateBlue2","OrangeRed3",
                          "HotPink3","maroon3","VioletRed3",
                          "magenta3","cyan","green","DarkGoldenrod",
                          "GreenYellow","sienna","plum"};
 
  [super buildObjects];
  [controlPanel setStateStopped];
  // Create a colormap that associates integer numbers
  // with named colors from the array allocated above 
  colormap = [Colormap create: [self getZone]];
  for(i=0;i<64;i++)
    [colormap setColor: i ToName: bugColors[i]];    

  // Create a list to hold the bugs
  bugList=[List create: self];

  // Create a RankedList instance which will
  // rank the bugs in descending order by
  // calling the getMoves method
  rankedList=[RankedList create: self];
  [rankedList setCollection: bugList];
  [rankedList setProbedSelector: M(getMoves)];
  rankedList=[rankedList createEnd];
  
  // Next, create a 2d window for display, set its size, zoom factor, title.
  raster=[ZoomRaster create: self];
  [raster setColormap: colormap];
  [raster setWidth: worldSize
                 Height: worldSize];
  [raster setZoomFactor: 30];
  [raster setWindowTitle: "LeftWorld"];
  [raster pack];                             // draw the window.

  // This 2d window will display the ordering of bugs, hence rankedRaster
  rankedRaster=[ZoomRaster create: self];
  [rankedRaster setColormap: colormap];
  [rankedRaster setWidth: worldSize
                 Height: worldSize];
  [rankedRaster setZoomFactor: 30];
  [rankedRaster setWindowTitle: "RankedWorld"];
  [rankedRaster pack];                             // draw the window.

  // Next create 2d lattices to hold the position of bugs, whether
  // physical location in the world or the "ranking"...
  world = [Grid2d createBegin: self];
  [world setSizeX: worldSize Y: worldSize];
  world = [world createEnd];
  [world fillWithObject: nil];

  rankedWorld = [Grid2d createBegin: self];
  [rankedWorld setSizeX: worldSize Y: worldSize];
  rankedWorld = [world createEnd];
  [rankedWorld fillWithObject: nil];


  // And also create an Object2dDisplay: this object draws bugs on
  // the world and ranked widgets.

  leftBugDisplay = [Object2dDisplay createBegin: self];
  [leftBugDisplay setDisplayWidget: raster];
  [leftBugDisplay setDiscrete2dToDisplay: world];
  [leftBugDisplay setObjectCollection: bugList];
  [leftBugDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
  leftBugDisplay = [leftBugDisplay createEnd];

  rankedBugDisplay = [Object2dDisplay createBegin: self];
  [rankedBugDisplay setDisplayWidget: rankedRaster];
  [rankedBugDisplay setDiscrete2dToDisplay: rankedWorld];
  [rankedBugDisplay setObjectCollection: bugList];
  [rankedBugDisplay setDisplayMessage: M(rankSelfOn:)];   // draw method
  rankedBugDisplay = [rankedBugDisplay createEnd];
  
  // This allows the user to ranked-click on the display to probe the bugs.
  [raster setButton: ButtonRight
               Client: leftBugDisplay
               Message: M(makeProbeAtX:Y:)];
  [rankedRaster setButton: ButtonRight
               Client: rankedBugDisplay
               Message: M(makeProbeAtX:Y:)];


  SET_WINDOW_GEOMETRY_RECORD_NAME(raster);
  SET_WINDOW_GEOMETRY_RECORD_NAME(rankedRaster);

  // Now create the agents (called bugs here)
  // We create as many bugs as the dimensions of
  // the world, basically so the ranked raster
  // can always display the ordering of all bugs
  for(i=0;i< worldSize; i++) {
    x=[uniformIntRand getIntegerWithMin: 0 withMax: worldSize];
    y=[uniformIntRand getIntegerWithMin: 0 withMax: worldSize];

    if([world getObjectAtX: x Y: y]==nil) {

         aBug = [Bug createBegin: self];
	 [aBug setX: x Y: y];
         aBug = [aBug createEnd];
       
	 [aBug setBugColor: i];

	 [bugList addLast: aBug];
	 [aBug setWorld: world rankedWorld: rankedWorld andList: bugList];
    }
  }

  
   return self;
}

- buildActions
{

  // Create the actions necessary for the simulation. 

  [super buildActions];

  // This arranges the order of the updates on each object
  displayActions = [ActionGroup create: self];
  // Tell the RankedList to order the bugs
  [displayActions createActionTo: rankedList message: M(update)];

  // Then tell each bug where he belongs
  [displayActions createActionTo: self message: M(setRank)];

  // Now erase both raster widgets
  [displayActions createActionTo: raster message: M(erase)];
  [displayActions createActionTo: rankedRaster message: M(erase)];

  // Then step all the bugs
  [displayActions createActionForEach: bugList message: M(step)];

  // Tell the bugs to color themselves on the world and ranked raster
  [displayActions createActionTo: leftBugDisplay message: M(display)];
  [displayActions createActionTo: rankedBugDisplay message: M(display)];

  // Then ask the rasters to update themselves
  [displayActions createActionTo: raster message: M(drawSelf)];
  [displayActions createActionTo: rankedRaster message: M(drawSelf)];

  // Finally update all the gui widgets
  [displayActions createActionTo: actionCache message: M(doTkEvents)];
  
  // The ordering of events is now set, put this on a repeating schedule
  displaySchedule = [Schedule createBegin: self];
  [displaySchedule setRepeatInterval: 1]; // note frequency!
  displaySchedule = [displaySchedule createEnd];  
  [displaySchedule at: 0 createAction: displayActions];
   
  return self;
}

- activateIn: swarmContext
{
// activateIn: - activate the schedules so they're ready to run.

  [super activateIn: swarmContext];

  // Now activate our schedule in ourselves. This arranges for the
  // execution of the schedule we built.

  [displaySchedule activateIn: self];

  // Activate returns the swarm activity - the thing that's ready to run.

  return [self getSwarmActivity];
}

-setRank {
  id list;
  id group;
  id aBug;
  int i,j;

  // This method erases previous rankings
  // and then checks where each bug is
  // relative to other bugs in the ranking
  // The top bug will then display itself
  // at the (0,0) location of the ranked raster
  // and the others in descending order, but
  // if there is a tie, bugs appear side by side
  [rankedWorld fillWithObject: nil];
  
  list=[rankedList getList];

  for(j=0;j<[list getCount];j++) {
    group=[list atOffset: j];
    for(i=0;i<[group getCount];i++) {
      aBug=[group atOffset: i];
      [aBug setRank: j andCol: i];
    }
  }


  return self;
}
  
@end








