// Bug.m					simpleObserverBug2

#import "Bug.h"

@implementation Bug

-setWorld: (id) w Food: (id) f Model: (id) m {
   world = w;
   foodSpace = f;
   modelSwarm=m;
   return self;
}

-createEnd {
   [super createEnd];

   worldXSize = [world getSizeX];
   worldYSize = [world getSizeY];
   return self;
}

-setX: (int) x Y: (int) y {
  xPos = x;
  yPos = y;
  
  return self;
}

-setLifetime: (int) l {
  lifetime=l;

  return self;
}

-step {

  int newX, newY;

  if(lifetime<=0)
    [self die];
  
  // If we found food last time continue in that
  // direction, else go in a random direction
  if(haveEaten!=1) {
    xDir= [uniformIntRand getIntegerWithMin: -1 withMax: 1];
    yDir= [uniformIntRand getIntegerWithMin: -1 withMax: 1];
  } 

  newX = xPos + xDir;
  newY = yPos + yDir;

  newX = (newX + worldXSize) % worldXSize;
  newY = (newY + worldYSize) % worldYSize;

  // We haven't found food yet
  haveEaten=0;
   
  if ([world getObjectAtX: newX Y: newY] == nil) {
    [world putObject: nil atX: xPos Y: yPos];
    xPos = newX;
    yPos = newY;
    [world putObject: self atX: newX Y: newY];
  }
     
  if ([foodSpace getValueAtX: xPos Y: yPos] == 1) {
    [foodSpace eatX: xPos Y: yPos];
    haveEaten = 1;
    lifetime++;
  } else {
    lifetime--;
  }

  return self;
}

-drawSelfOn: (id <Raster>) r {
  if(haveEaten==1)
    [r drawPointX: xPos Y: yPos Color: 2];
  else
    [r drawPointX: xPos Y: yPos Color: 3];
  return self;
}

-die {
  [modelSwarm kill: self];
  return self;
}
  
@end

  


