/* 
  FHPNeighborhood.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  JAN-1997

  A fhpNeighborhood can cycle through the values of the enumerated
  type TriNeighborCode (see TriNeighborCode.h) corresponding to the
  nearest neighbors on a regular triangular lattice - i.e.
  TriNorth, TriNorthEast, TriSouthEast, TriSouth, TriSouthWest 
  and TriNorthWest.

*/

#import <objectbase/SwarmObject.h>

#import "Neighborhood.h"

@interface FHPneighborhood: SwarmObject <Neighborhood>
{
  id uniformUnsigned;
}


/* The -next and -previous methods each rotate the
  given neighbor by 60 degrees.  -next cycles in the
  order TriNorth-TriNorthEast-TriSouthEast-TriSouth-
  TriSouthWest-TriNorthWest;
  -previous cycles in the reverse order.  
*/


@end
