/* 
  Lattice.h

  This defines the <Lattice> protocol, which is an
  attempt at a generalised protocol suitable for "any"
  kind of "regular", discrete lattice.  Conceptually,
  most of the functionality of such a Lattice will
  actually be offered via soime kind of tailored
  "Coord" objects, which identify "positions" in the
  Lattice. (See Coord.h) The Lattice object itself is
  mainly confined to providing Coord objects, through
  which the interaction can then be carried out.
  
  Barry McMullin <mcmullin@eeng.dcu.ie>
  FEB-1997

*/

#import "Neighborhood.h"

@protocol Lattice <Neighborhood>
/*
  Note:

  +create: (id) aZone setGenerator (id) generator;

  Defined in <Neighborhood> protocol, but *not* supported.
*/

- setGenerator: generator;  // Create Phase only.
/* 
  If you wish to use any of the randomizing methods of the 
  underlying Neighborhood, then -setGenerator: *must* be
  invoked during the create phase on the Lattice object.
*/

- createOriginCoord: aZone;
- createMaxCoord: aZone;

@end
