/* 
  Neighborhood.h

  Barry McMullin <mcmullin@eeng.dcu.ie>
  JAN-1997

*/

#import <defobj.h>
#import "NeighborCode.h"

@protocol Neighborhood

/* The precise meanings of -next and -previous are specific
   to a particular neighborhood class.

  The -random method picks a random neighbor (with 
  uniform probability function) and returns it.  */

- (BOOL)isValidNeighborCode: (NeighborCode)inNeighbor;
- (NeighborCode)getInitialNeighborCode;
- (NeighborCode)getNextNeighborCode: (NeighborCode) inNeighbor;
- (NeighborCode)getPreviousNeighborCode: (NeighborCode) inNeighbor;
- (NeighborCode)getOppositeNeighborCode: (NeighborCode) inNeighbor;

+ create: aZone setGenerator: generator;
/* 
  If you wish to use any of the randomizing methods of the protocol,
  the object *must* be created via the create:setGenerator method.
  Otherwise it can be created with the normal create: method.
*/

- (NeighborCode)getRandomNeighborCode;
- (NeighborCode)getRandomNeighborCodeExcluding: (NeighborCode)inNeighbor;

- (void)drop; // Overridden.

@end

