/* 
  Tipsybug.m

  Barry McMullin <mcmullin@eeng.dcu.ie>
  JAN-1997

*/


#import <simtools.h>

#import "Globals.h"
#import "ModelSwarm.h"
#import "Tipsybug.h"

@implementation Tipsybug

-setRandomMoveProbability: (double) p {
  randomMoveProbability = (double) p;
  return self;
}

-step {
  unsigned neighborCode;

  if ([bernoulli getTossWithProb: randomMoveProbability]) {
    neighborCode = [[coord getLatticeObject] getRandomNeighborCode];
    if (![self attemptSwapToNeighbor: neighborCode])
      [InternalError raiseEvent: 
      "Failed swap of tbug %08x to neighborCode %d.", 
       self, neighborCode];
  }

  return self;
}


@end
