// Turmites application. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

#import "TurmiteObserverSwarm.h"
#import "TurmiteModelSwarm.h"
#import <simtoolsgui.h>
#import <gui.h>

@implementation TurmiteObserverSwarm

// createBegin: here we set up the default observation parameters.

+ createBegin: aZone
{
  TurmiteObserverSwarm *obj;
  id <ProbeMap> probeMap;
  
  // Superclass createBegin to allocate ourselves.

  obj = [super createBegin: aZone];

  // Fill in the relevant parameters (only one, in this case).

  obj->displayFrequency = 1;

  // Also, build a customized probe map. Without a probe map, the default
  // is to show all variables and messages. Here we choose to
  // customize the appearance of the probe, give a nicer interface.

  probeMap = [EmptyProbeMap createBegin: aZone];
  [probeMap setProbedClass: [self class]];
  probeMap = [probeMap createEnd];

  // Add in a bunch of variables, one per simulation parameter

  [probeMap addProbe: [probeLibrary getProbeForVariable: "displayFrequency"
				    inClass: [self class]]];

  // Now install our custom probeMap into the probeLibrary.

  [probeLibrary setProbeMap: probeMap For: [self class]];

  return obj;
}

// createEnd: create objects we know we'll need. In this case, none,
// but you might want to override this.

- createEnd
{
  return [super createEnd];
}

// Create the objects used in the display of the model. This code is
// fairly complicated because we build a fair number of widgets. It's
// also a good example of how to use the display code.

- buildObjects
{
  id modelZone;					  // zone for model.

  [super buildObjects];
  
  // First, we create the model that we're actually observing. The
  // model is a subswarm of the observer. We also create the model in
  // its own zone, so storage is segregated.

  modelZone = [Zone create: [self getZone]];
  turmiteModelSwarm = [TurmiteModelSwarm create: modelZone];
  
  // Now create probe objects on the model and ourselves. This gives a
  // simple user interface to let the user change parameters.

  [probeDisplayManager createProbeDisplayFor: turmiteModelSwarm];
  [probeDisplayManager createProbeDisplayFor: self];

  // Instruct the control panel to wait for a button event: we halt here
  // until someone hits a control panel button so the user can get a
  // chance to fill in parameters before the simulation runs

  [controlPanel setStateStopped];

  // OK - the user has specified all the parameters for the simulation.
  // Now we're ready to start.

  // First, let the model swarm build its objects.

  [turmiteModelSwarm buildObjects];

  // Now get down to building our own display objects.

  // First, create a colormap: this is a global resource, the information
  // here is used by lots of different objects.

  colormap = [Colormap create: [self getZone]];

  [colormap setColor: 0 ToName: "black"];
  [colormap setColor: 1 ToName: "red"];
  [colormap setColor: 2 ToName: "green"];
  [colormap setColor: 3 ToName: "blue"];
  [colormap setColor: 4 ToName: "yellow"];
  [colormap setColor: 5 ToName: "cyan"];
  [colormap setColor: 6 ToName: "aquamarine"];
  [colormap setColor: 7 ToName: "salmon"];
  [colormap setColor: 8 ToName: "GreenYellow"];
  [colormap setColor: 9 ToName: "cyan3"];
  [colormap setColor: 10 ToName: "purple"];
  [colormap setColor: 11 ToName: "brown"];
  [colormap setColor: 12 ToName: "grey"];
  [colormap setColor: 13 ToName: "SkyBlue"];  
  [colormap setColor: 14 ToName: "blue3"];
  [colormap setColor: 15 ToName: "azure"];
  [colormap setColor: 16 ToName: "OrangeRed"];
  [colormap setColor: 17 ToName: "aquamarine1"];
  [colormap setColor: 18 ToName: "black"];
  [colormap setColor: 19 ToName: "red"];
  [colormap setColor: 20 ToName: "green"];
  [colormap setColor: 21 ToName: "blue"];
  [colormap setColor: 22 ToName: "yellow"];
  [colormap setColor: 23 ToName: "cyan"];
  [colormap setColor: 24 ToName: "aquamarine"];
  [colormap setColor: 25 ToName: "salmon"];
  [colormap setColor: 26 ToName: "GreenYellow"];
  [colormap setColor: 27 ToName: "cyan3"];
  [colormap setColor: 28 ToName: "purple"];
  [colormap setColor: 29 ToName: "brown"];
  [colormap setColor: 30 ToName: "grey"];
  [colormap setColor: 31 ToName: "SkyBlue"];
  [colormap setColor: 32 ToName: "blue3"];
  [colormap setColor: 33 ToName: "azure"];
  [colormap setColor: 34 ToName: "OrangeRed"];
  [colormap setColor: 35 ToName: "aquamarine1"];


  // Next, create a 2d window for display, set its size, zoom factor, title.

  worldRaster = [ZoomRaster create: [self getZone]];
  [worldRaster setColormap: colormap];
  [worldRaster setZoomFactor: 4];
  [worldRaster setWidth: [[turmiteModelSwarm getTape] getSizeX]
	       Height: [[turmiteModelSwarm getTape] getSizeY]];
  [worldRaster setWindowTitle: "Turmite World"];
  [worldRaster pack];				  // draw the window.

  // Now create a Value2dDisplay: this is a special object that will
  // display arbitrary 2d value arrays on a given Raster widget.

  tapeDisplay = [Value2dDisplay createBegin: [self getZone]];
  [tapeDisplay setDisplayWidget: worldRaster colormap: colormap];
  [tapeDisplay setDiscrete2dToDisplay: [turmiteModelSwarm getTape]];
  tapeDisplay = [tapeDisplay createEnd];

  // And also create an Object2dDisplay: this object draws heatbugs on
  // the worldRaster widget for us, and also receives probes.

  turmiteDisplay = [Object2dDisplay createBegin: [self getZone]];
  [turmiteDisplay setDisplayWidget: worldRaster];
  [turmiteDisplay setDiscrete2dToDisplay: [turmiteModelSwarm getTape]];
  [turmiteDisplay setObjectCollection: [turmiteModelSwarm getTurmiteList]];
  [turmiteDisplay setDisplayMessage: M(drawSelfOn:)];   // draw method
  turmiteDisplay = [turmiteDisplay createEnd];

  // Also, tell the world raster to send mouse clicks to the turmiteDisplay
  // this allows the user to right-click on the display to probe the mites.

  [worldRaster setButton: ButtonRight Client: turmiteDisplay Message: M(makeProbeAtX:Y:)];

  // All done - we're ready to build a schedule and go.

  return self;
}  

// Create the actions necessary for the simulation. This is where
// the schedule is built (but not run!)
// Here we create a display schedule - this is used to display the
// state of the world and check for user input. This schedule should
// be thought of as independent from the model - in particular, you
// will also want to run the model without any display.

- buildActions 
{
  [super buildActions];
  
  // First, let our model swarm build its own schedule.

  [turmiteModelSwarm buildActions];
  
  // Create an ActionGroup for display: a bunch of things that occur in
  // a specific order, but at one step of simulation time. Some of these
  // actions could be executed in parallel, but we don't explicitly
  // notate that here.

  displayActions = [ActionGroup create: [self getZone]];

  // Schedule up the methods to draw the display of the world

  [displayActions createActionTo: tapeDisplay         message: M(display)];
  [displayActions createActionTo: turmiteDisplay      message: M(display)];
  [displayActions createActionTo: worldRaster         message: M(drawSelf)];

  // Schedule the update of the probe displays

  [displayActions createActionTo: probeDisplayManager message: M(update)];

  // Finally, schedule an update for the whole user interface code.
  // This is crucial: without this, no graphics update and the control
  // panel will be dead. It's best to put it at the end of the display schedule

  [displayActions createActionTo: actionCache        message: M(doTkEvents)];

  // And the display schedule. Note the repeat interval is set from our
  // own Swarm data structure. Display is frequently the slowest part of a
  // simulation, so redrawing less frequently can be a help.

  displaySchedule = [Schedule createBegin: [self getZone]];
  [displaySchedule setRepeatInterval: displayFrequency]; // note frequency!
  displaySchedule = [displaySchedule createEnd];
  [displaySchedule at: 0 createAction: displayActions];
  
  return self;
}  

// activateIn: - activate the schedules so they're ready to run.
// The swarmContext argument has to do with what we were activated *in*.
// Typically the ObserverSwarm is the top-level Swarm, so it's activated
// in "nil". But other Swarms and Schedules and such will be activated
// inside of us.

- activateIn: swarmContext
{
  // First, activate ourselves (just pass along the context).

  [super activateIn: swarmContext];

  // Activate the model swarm in ourselves. The model swarm is a
  // subswarm of the observer swarm.

  [turmiteModelSwarm activateIn: self];

  // Now activate our schedule in ourselves. This arranges for the
  // execution of the schedule we built.

  [displaySchedule activateIn: self];
  
  // Activate returns the swarm activity - the thing that's ready to run.

  return [self getActivity];
}

// You could override the "go" method here if you want something special
// to happen when the model and observer actually start running. But
// the default GUISwarm go is probably good enough.

@end
