// Turmites application. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// The Turmite Model swarm encapsulates all the objects used in the
// simulated turmite world itself (but not the user interface objects)

#import <objectbase/Swarm.h>
#import "Turmite.h"
#import "TapeSpace.h"

@interface TurmiteModelSwarm: Swarm
{
  int numMites;					  // simulation parameters
  int numStates;
  int numTapeStates;
  int numMoves;
  int worldXSize, worldYSize;

  id modelActions;				  // scheduling data structures
  id modelSchedule;

  id turmiteList;				  // list of all the turmites 
  id <TapeSpace> tape;				  // the world
}

- getTurmiteList;				  // access methods into the
- (id <TapeSpace>)getTape;		  	  // model swarm. These methods
						  // allow the model swarm
						  // to be observed.

+ createBegin: aZone;	                          // extra methods you
- createEnd;					  // provide for Swarms
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end
