// Turmites application. Copyright  1996-2000 Swarm Development Group.
// This library is distributed without any warranty; without even the
// implied warranty of merchantability or fitness for a particular purpose.
// See file LICENSE for details and terms of copying.

// The TurmiteObserverSwarm is a swarm of objects set up to observe a
// Turmites model when the graphical interface is running. The most
// important object is the turmiteModelSwarm, but we also have
// graphical windows and data analysis and stuff.

#import <simtoolsgui/GUISwarm.h>
#import "TurmiteModelSwarm.h"
#import <gui.h> // Colormap 
#import <space.h> // Value2dDisplay, Object2dDisplay

@interface TurmiteObserverSwarm: GUISwarm
{
  int displayFrequency;				  // one parameter: update freq

  id displayActions;				  // schedule data structs
  id displaySchedule;

  TurmiteModelSwarm *turmiteModelSwarm;	          // the Swarm we're observing

  // Lots of display objects. First, widgets

  id <Colormap> colormap;			  // allocate colours
  id <ZoomRaster> worldRaster;			  // 2d display widget

  // Now, higher order display and data objects

  id <Value2dDisplay> tapeDisplay;		  // display the tape 
  id <Object2dDisplay> turmiteDisplay;		  // display the turmites
}

// Methods overriden to make the Swarm.

+ createBegin: aZone;
- createEnd;
- buildObjects;
- buildActions;
- activateIn: swarmContext;

@end
