#import "grid.h"

#include <stdio.h>

#import <collections/List_linked.h>
#import <defobj/defalloc.h>

extern id _obj_sessionZone;  // to confirm cleanup of display names

@interface MyList : List_linked
+ create: aZone;
@end

@implementation MyList

+ create: aZone
{
  List_linked  *newList;

  newList = [aZone allocIVars: [List_linked self]];
  setMappedAlloc( newList );
  return newList;
}

@end

int main(void)
{
  id    aZone, aList, aTurtle, index, newList;
  int   i;
  char  buffer[50];

  initModule( grid );

  aZone = [Zone create: globalZone];
  aList = [MyList create: aZone];

  printf( "count: %d\n", [aList getCount] );

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: aZone];
    [aTurtle turn: -1];
    [aTurtle move: i * 10];
    [aList addLast: aTurtle];
    if ( i % 2 ) {
      sprintf( buffer, "turtle number %d", i );
      [aTurtle setDisplayName: buffer];
    }
  }

  printf( "count: %d\n", [aList getCount] );

  printf( "\n[aZone xfprintid]\n" );
  [aZone xfprintid];
  printf( "\n" );

  index = [aList begin: scratchZone];
  while ( (aTurtle = [index next]) ) {
    [aTurtle print];
  }
  [index drop];

  [aList addFirst: [aList removeLast]];
  [aList addFirst: [aList removeLast]];
  [aList addLast: [aList removeFirst]];

  printf( "count: %d\n", [aList getCount] );
  index = [aList begin: scratchZone];
  for ( [index setLoc: End]; (aTurtle = [index prev]); ) {
    [aTurtle print];
  }

  printf( "turtle located at offset 3: " );
  [[index setOffset: 3] print];
  printf( "turtle removed at offset 3: " );
  [[index remove] print];

  [index setLoc: Start];
  while ( (aTurtle = [index next]) );

  [aList forEach: @selector( print )];

  newList = [List createBegin: aZone];
  [newList setInitialValue: aList];
  newList = [newList createEnd];
  [aList drop];

  printf( "new list count: %d\n", [newList getCount] );
  [newList forEach: @selector( print )];

  aList = [newList copy: aZone];
  printf( "copied list count: %d\n", [aList getCount] );
  [aList forEach: @selector( print )];

  printf( "\nsession zone before drop of all turtles\n" );
  [_obj_sessionZone xprint];
  [aList deleteAll];
  [aList drop];

  printf( "\nsession zone after drop\n" );
  [_obj_sessionZone xprint];
  printf( "\n" );

  [newList drop];
  [aZone xprint];
  [aZone drop];
  return 0;
}
