#import "grid.h"

#include <stdio.h>

int main(void)
{
  id   aZone, aMap, aTurtle, index;
  int   i;

  initModule( grid );

  aZone = [Zone create: globalZone];
  aMap  = [Map createBegin: aZone];
  [aMap setCompareFunction: compareIntegers];
  aMap = [aMap createEnd];

  printf( "count: %d\n", [aMap getCount] );

  for ( i = 0; i < 10; i++ ) {
    aTurtle = [GridTurtle create: aZone];
    [aTurtle turn: -1];
    [aTurtle move: (10 - i) * 10];
    [aMap at: (id)(10 - i) insert: aTurtle];
  }

  printf( "count: %d\n", [aMap getCount] );

  index = [aMap begin: scratchZone];
  while ( (aTurtle = [index next]) ) {
    printf( "%d: ", (int)[index getKey] );
    [aTurtle print];
  }
  [index drop];

  [[aMap getFirst] print];
  [[aMap getLast] print];

  [aMap xprint];
  [aMap drop];
  [aZone xprint];
  [aZone drop];
  return 0;
}
